"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerConfiguration = LayerConfiguration;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _workspace_panel = require("../../../editor_frame_service/editor_frame/workspace_panel");
var _config_panel = require("../../../editor_frame_service/editor_frame/config_panel/config_panel");
var _service = require("../../../data_views_service/service");
var _state_management = require("../../../state_management");
var _lens_slice = require("../../../state_management/lens_slice");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/shared/edit_on_the_fly/layer_configuration_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LayerConfiguration({
  attributes,
  coreStart,
  startDependencies,
  visualizationMap,
  datasourceMap,
  datasourceId,
  framePublicAPI,
  hasPadding,
  setIsInlineFlyoutVisible,
  getUserMessages,
  onlyAllowSwitchToSubtypes,
  lensAdapters,
  dataLoading$,
  setCurrentAttributes,
  updateSuggestion,
  parentApi,
  panelId,
  closeFlyout,
  canEditTextBasedQuery,
  editorContainer
}) {
  var _visualization$active;
  const dispatch = (0, _state_management.useLensDispatch)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    visualization
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const activeVisualization = visualizationMap[(_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : attributes.visualizationType];
  const indexPatternService = (0, _react.useMemo)(() => (0, _service.createIndexPatternService)({
    dataViews: startDependencies.dataViews,
    uiActions: startDependencies.uiActions,
    core: coreStart,
    updateIndexPatterns: (newIndexPatternsState, options) => {
      dispatch((0, _state_management.updateIndexPatterns)(newIndexPatternsState));
    },
    replaceIndexPattern: (newIndexPattern, oldId, options) => {
      dispatch((0, _lens_slice.replaceIndexpattern)({
        newIndexPattern,
        oldId
      }));
    }
  }), [coreStart, dispatch, startDependencies.dataViews, startDependencies.uiActions]);
  const layerPanelsProps = {
    attributes,
    lensAdapters,
    dataLoading$,
    framePublicAPI,
    datasourceMap,
    visualizationMap,
    core: coreStart,
    dataViews: startDependencies.dataViews,
    uiActions: startDependencies.uiActions,
    hideLayerHeader: datasourceId === 'textBased',
    // TODO: remove this prop once we display the chart switch in Discover
    onlyAllowSwitchToSubtypes,
    indexPatternService,
    setIsInlineFlyoutVisible,
    getUserMessages,
    data: startDependencies.data,
    setCurrentAttributes,
    updateSuggestion,
    parentApi,
    panelId,
    closeFlyout,
    canEditTextBasedQuery,
    editorContainer
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: ${hasPadding ? euiTheme.size.s : 0};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_workspace_panel.VisualizationToolbar, {
    activeVisualization: activeVisualization,
    framePublicAPI: framePublicAPI,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_config_panel.ConfigPanelWrapper, (0, _extends2.default)({}, layerPanelsProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  })));
}