"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = exports.getGridAttrs = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _common = require("@kbn/data-plugin/common");
var _lens_suggestions_api = require("../../../lens_suggestions_api");
var _chart_type_session_storage = require("../../../chart_type_session_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDSLFilter = (queryService, uiSettings, timeFieldName) => {
  const esQueryConfigs = (0, _public.getEsQueryConfig)(uiSettings);
  const kqlQuery = queryService.queryString.getQuery();
  const filters = queryService.filterManager.getFilters();
  const timeFilter = queryService.timefilter.timefilter.getTime() && (0, _common.getTime)(undefined, queryService.timefilter.timefilter.getTime(), {
    fieldName: timeFieldName
  });
  return (0, _esQuery.buildEsQuery)(undefined, kqlQuery || [], [...(filters !== null && filters !== void 0 ? filters : []), ...(timeFilter ? [timeFilter] : [])], esQueryConfigs);
};
const getGridAttrs = async (query, adHocDataViews, data, uiSettings, abortController, esqlVariables = []) => {
  const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  const dataViewSpec = adHocDataViews.find(adHoc => {
    return adHoc.name === indexPattern;
  });
  const dataView = dataViewSpec ? await data.dataViews.create(dataViewSpec) : await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, data.dataViews);
  const filter = getDSLFilter(data.query, uiSettings, dataView.timeFieldName);
  const results = await (0, _esqlUtils.getESQLResults)({
    esqlQuery: query.esql,
    search: data.search.search,
    signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal,
    filter,
    dropNullColumns: true,
    timeRange: data.query.timefilter.timefilter.getAbsoluteTime(),
    variables: esqlVariables
  });
  let queryColumns = results.response.columns;
  // Use all_columns property if it exists in the payload
  // which has all columns regardless if they have data or not
  if (results.response.all_columns) {
    queryColumns = results.response.all_columns;
  }
  const columns = (0, _esqlUtils.formatESQLColumns)(queryColumns);
  return {
    rows: results.response.values,
    dataView,
    columns
  };
};
exports.getGridAttrs = getGridAttrs;
const getSuggestions = async (query, data, uiSettings, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController, setDataGridAttrs, esqlVariables = [], shouldUpdateAttrs = true, preferredVisAttributes) => {
  try {
    var _suggestionsApi;
    const {
      dataView,
      columns,
      rows
    } = await getGridAttrs(query, adHocDataViews, data, uiSettings, abortController, esqlVariables);
    const updatedWithVariablesColumns = esqlVariables.length ? (0, _esqlUtils.mapVariableToColumn)(query.esql, esqlVariables, columns) : columns;
    setDataGridAttrs === null || setDataGridAttrs === void 0 ? void 0 : setDataGridAttrs({
      rows,
      dataView,
      columns: updatedWithVariablesColumns
    });
    if (!shouldUpdateAttrs) {
      return;
    }

    // User deliberately changed the chart type
    const userDefinedChartType = (0, _chart_type_session_storage.readUserChartTypeFromSessionStorage)();
    const preferredChartType = userDefinedChartType ? (0, _visualizationUtils.mapVisToChartType)(userDefinedChartType) : undefined;
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(false),
      fieldName: '',
      textBasedColumns: updatedWithVariablesColumns,
      query
    };
    const allSuggestions = (_suggestionsApi = (0, _lens_suggestions_api.suggestionsApi)({
      context,
      dataView,
      datasourceMap,
      visualizationMap,
      preferredChartType,
      preferredVisAttributes
    })) !== null && _suggestionsApi !== void 0 ? _suggestionsApi : [];

    // Lens might not return suggestions for some cases, i.e. in case of errors
    if (!allSuggestions.length) return undefined;
    const firstSuggestion = allSuggestions[0];
    const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
      filters: [],
      query,
      suggestion: firstSuggestion,
      dataView
    });
    return {
      ...attrs,
      state: {
        ...attrs.state,
        needsRefresh: false
      }
    };
  } catch (e) {
    setErrors === null || setErrors === void 0 ? void 0 : setErrors([e]);
  }
  return undefined;
};
exports.getSuggestions = getSuggestions;