"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreePanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ingestPipelinesShared = require("@kbn/ingest-pipelines-shared");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/flyout_content/tree_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TreePanel = exports.TreePanel = /*#__PURE__*/_react.default.memo(({
  pipelineTree,
  selectedPipeline,
  clickTreeNode,
  setTreeRootStack,
  isExtension
}) => {
  var _documentation$getDoc;
  const {
    services: {
      documentation
    }
  } = (0, _shared_imports.useKibana)();
  const pushTreeStack = (0, _react.useCallback)(name => {
    clickTreeNode(name);
    setTreeRootStack(prevStack => [...prevStack, name]);
  }, [clickTreeNode, setTreeRootStack]);
  const popTreeStack = (0, _react.useCallback)(() => {
    setTreeRootStack(prevStack => {
      if (prevStack.length <= 1) return prevStack; // can't pop the last one
      return prevStack.slice(0, -1);
    });
  }, [setTreeRootStack]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    "data-test-subj": "pipelineTreePanel",
    style: {
      overflowY: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "pipelineTreeTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.pipelineTree.title', {
    defaultMessage: 'Ingest pipeline hierarchy'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelineDetails.pipelineTree.description",
    defaultMessage: "A tree visualization of your ingest pipeline, showing how {pipelineProcessorsLink} are invoking other pipelines",
    values: {
      pipelineProcessorsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (_documentation$getDoc = documentation.getDocLinks()) === null || _documentation$getDoc === void 0 ? void 0 : _documentation$getDoc.links.ingest.pipeline,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.pipelineTree.pipelineProcessorsDocsLink', {
        defaultMessage: 'pipeline processors'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_ingestPipelinesShared.PipelineStructureTree, {
    pipelineTree: pipelineTree,
    selectedPipeline: selectedPipeline,
    clickTreeNode: clickTreeNode,
    isExtension: isExtension,
    clickMorePipelines: name => pushTreeStack(name),
    goBack: popTreeStack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }));
});