"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pipelineFormSchema = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _utils = require("../../lib/utils");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/schema.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField,
  isJsonField,
  containsCharsField
} = _shared_imports.fieldValidators;
const {
  toInt
} = _shared_imports.fieldFormatters;
const DISALLOWED_CHARS = [',', '*'];
const pipelineFormSchema = exports.pipelineFormSchema = {
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.form.nameFieldLabel', {
      defaultMessage: 'Name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.form.pipelineNameRequiredError', {
        defaultMessage: 'Name is required.'
      }))
    }, {
      validator: containsCharsField({
        message: _i18n.i18n.translate('xpack.ingestPipelines.form.pipelineInvalidCharactersInNameError', {
          defaultMessage: `Should not contain any of the following characters: {notAllowedChars}`,
          values: {
            notAllowedChars: DISALLOWED_CHARS.join(', ')
          }
        }),
        chars: DISALLOWED_CHARS
      })
    }]
  },
  description: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.ingestPipelines.form.descriptionFieldLabel', {
      defaultMessage: 'Description (optional)'
    })
  },
  version: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    label: _i18n.i18n.translate('xpack.ingestPipelines.form.versionFieldLabel', {
      defaultMessage: 'Version (optional)'
    }),
    formatters: [toInt]
  },
  _meta: {
    label: _i18n.i18n.translate('xpack.ingestPipelines.form.metaFieldLabel', {
      defaultMessage: '_meta field data (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.metaHelpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 17
          }
        }, JSON.stringify({
          arbitrary_data: 'anything_goes'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }),
    serializer: value => {
      const result = (0, _utils.parseJson)(value, false);
      // If an empty object was passed, strip out this value entirely.
      if (!Object.keys(result).length) {
        return undefined;
      }
      return result;
    },
    deserializer: value => (0, _utils.stringifyJson)(value, false),
    validations: [{
      validator: isJsonField(_i18n.i18n.translate('xpack.ingestPipelines.form.validation.metaJsonError', {
        defaultMessage: 'The input is not valid.'
      }), {
        allowEmptyString: true
      })
    }]
  }
};