"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _shared_imports = require("../../../shared_imports");
var _utils = require("./utils");
var _pipeline_request_flyout = require("./pipeline_request_flyout");
var _pipeline_form_fields = require("./pipeline_form_fields");
var _pipeline_form_error = require("./pipeline_form_error");
var _schema = require("./schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/pipeline_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultFormValue = Object.freeze({
  name: '',
  description: '',
  processors: [],
  on_failure: [],
  _meta: {}
});
const PipelineForm = ({
  defaultValue = defaultFormValue,
  onSave,
  isSaving,
  saveError,
  isEditing,
  onCancel,
  canEditName
}) => {
  const {
    overlays,
    history,
    application: {
      navigateToUrl
    },
    http
  } = (0, _shared_imports.useKibana)().services;
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const [areProcessorsDirty, setAreProcessorsDirty] = (0, _react.useState)(false);
  const [hasSubmittedForm, setHasSubmittedForm] = (0, _react.useState)(false);
  const {
    processors: initialProcessors,
    on_failure: initialOnFailureProcessors,
    ...defaultFormValues
  } = defaultValue;
  const [processorsState, setProcessorsState] = (0, _react.useState)({
    processors: initialProcessors,
    onFailure: initialOnFailureProcessors
  });
  const processorStateRef = (0, _react.useRef)();
  const handleSave = async (formData, isValid) => {
    if (!isValid) {
      return;
    }
    if (processorStateRef.current) {
      const state = processorStateRef.current;
      if (await state.validate()) {
        // We only want to show unsaved changed prompts to the user when the form
        // hasnt been submitted.
        setHasSubmittedForm(true);

        // Save the form state, this will also trigger a redirect to pipelines list
        onSave({
          ...formData,
          ...state.getData()
        });
      }
    }
  };
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _schema.pipelineFormSchema,
    defaultValue: defaultFormValues,
    onSubmit: handleSave
  });
  const isFormDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const onEditorFlyoutOpen = (0, _react.useCallback)(() => {
    setIsRequestVisible(false);
  }, [setIsRequestVisible]);
  const saveButtonLabel = isSaving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.savingButtonLabel",
    defaultMessage: "Saving...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }) : isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.saveButtonLabel",
    defaultMessage: "Save pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.createButtonLabel",
    defaultMessage: "Create pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
  const onProcessorsChangeHandler = (0, _react.useCallback)(arg => {
    var _processorStateRef$cu;
    processorStateRef.current = arg;
    const currentProcessorsState = (_processorStateRef$cu = processorStateRef.current) === null || _processorStateRef$cu === void 0 ? void 0 : _processorStateRef$cu.getData();

    // Calculate if the current processor state has changed compared to the
    // initial processors state.
    setAreProcessorsDirty(!(0, _utils.deepEqualIgnoreUndefined)({
      processors: (processorsState === null || processorsState === void 0 ? void 0 : processorsState.processors) || [],
      onFailure: (processorsState === null || processorsState === void 0 ? void 0 : processorsState.onFailure) || []
    }, {
      processors: (currentProcessorsState === null || currentProcessorsState === void 0 ? void 0 : currentProcessorsState.processors) || [],
      onFailure: (currentProcessorsState === null || currentProcessorsState === void 0 ? void 0 : currentProcessorsState.on_failure) || []
    }));
  }, [processorsState]);

  /*
    We need to check if the form is dirty and also if the form has been submitted.
    Because on form submission we also redirect the user to the pipelines list,
    and this could otherwise trigger an unwanted unsaved changes prompt.
  */
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    titleText: _i18n.i18n.translate('xpack.ingestPipelines.form.unsavedPrompt.title', {
      defaultMessage: 'Exit without saving changes?'
    }),
    messageText: _i18n.i18n.translate('xpack.ingestPipelines.form.unsavedPrompt.body', {
      defaultMessage: 'The data will be lost if you leave this page without saving the pipeline changes.'
    }),
    hasUnsavedChanges: (isFormDirty || areProcessorsDirty) && !hasSubmittedForm,
    openConfirm: overlays.openConfirm,
    history,
    http,
    navigateToUrl
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "pipelineForm",
    isInvalid: form.isSubmitted && !form.isValid && !form.isSubmitting,
    error: form.getErrors(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, saveError && /*#__PURE__*/_react.default.createElement(_pipeline_form_error.PipelineFormError, {
    error: saveError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_pipeline_form_fields.PipelineFormFields, {
    onLoadJson: ({
      processors,
      on_failure: onFailure
    }) => {
      setProcessorsState({
        processors,
        onFailure
      });
    },
    onEditorFlyoutOpen: onEditorFlyoutOpen,
    processors: processorsState.processors,
    onFailure: processorsState.onFailure,
    onProcessorsUpdate: onProcessorsChangeHandler,
    hasVersion: Boolean(defaultValue.version),
    hasMeta: Boolean(defaultValue._meta && Object.keys(defaultValue._meta).length),
    isEditing: isEditing,
    canEditName: canEditName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    iconType: "check",
    onClick: form.submit,
    "data-test-subj": "submitButton",
    disabled: form.isSubmitted && form.isValid === false,
    isLoading: isSaving,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, saveButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "showRequestLink",
    onClick: () => setIsRequestVisible(prevIsRequestVisible => !prevIsRequestVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.hideRequestButtonLabel",
    defaultMessage: "Hide request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.showRequestButtonLabel",
    defaultMessage: "Show request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 17
    }
  })))), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_pipeline_request_flyout.PipelineRequestFlyout, {
    readProcessors: () => {
      var _processorStateRef$cu2;
      return ((_processorStateRef$cu2 = processorStateRef.current) === null || _processorStateRef$cu2 === void 0 ? void 0 : _processorStateRef$cu2.getData()) || {
        processors: [],
        on_failure: []
      };
    },
    closeFlyout: () => setIsRequestVisible(prevIsRequestVisible => !prevIsRequestVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }));
};
exports.PipelineForm = PipelineForm;