"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../shared_imports");
var _context = require("../../context");
var _serialize = require("../../serialize");
var _use_is_mounted = require("../../use_is_mounted");
var _test_pipeline_flyout = require("./test_pipeline_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_flyout.container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestPipelineFlyout = ({
  onClose,
  activeTab,
  setActiveTab,
  processors
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const isMounted = (0, _use_is_mounted.useIsMounted)();
  const {
    testPipelineData,
    testPipelineDataDispatch,
    updateTestOutputPerProcessor
  } = (0, _context.useTestPipelineContext)();
  const {
    config: {
      documents: cachedDocuments,
      verbose: cachedVerbose
    }
  } = testPipelineData;
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      documents: cachedDocuments || ''
    }
  });
  const [isRunningTest, setIsRunningTest] = (0, _react.useState)(false);
  const [testingError, setTestingError] = (0, _react.useState)(null);
  const [testOutput, setTestOutput] = (0, _react.useState)(undefined);
  const handleTestPipeline = (0, _react.useCallback)(async ({
    documents,
    verbose
  }, updateProcessorOutput) => {
    const serializedProcessors = (0, _serialize.serialize)({
      pipeline: processors
    });
    setIsRunningTest(true);
    setTestingError(null);
    const {
      error,
      data: currentTestOutput
    } = await services.api.simulatePipeline({
      documents,
      verbose,
      pipeline: {
        ...serializedProcessors
      }
    });
    if (!isMounted.current) {
      return {
        isSuccessful: false
      };
    }
    setIsRunningTest(false);
    if (error) {
      setTestingError(error);

      // reset the per-processor output
      // this is needed in the scenario where the pipeline has already executed,
      // but you modified the sample documents and there was an error on re-execution
      testPipelineDataDispatch({
        type: 'updateOutputPerProcessor',
        payload: {
          isExecutingPipeline: false,
          testOutputPerProcessor: undefined
        }
      });
      return {
        isSuccessful: false
      };
    }
    testPipelineDataDispatch({
      type: 'updateConfig',
      payload: {
        config: {
          documents,
          verbose
        }
      }
    });

    // We sometimes need to manually refresh the per-processor output
    // e.g., when clicking the "Refresh output" button and there have been no state changes
    if (updateProcessorOutput) {
      updateTestOutputPerProcessor(documents, processors);
    }
    setTestOutput(currentTestOutput);
    services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.successNotificationText', {
      defaultMessage: 'Pipeline executed'
    }), {
      toastLifeTimeMs: 1000
    });
    return {
      isSuccessful: true
    };
  }, [isMounted, processors, services.api, services.notifications.toasts, testPipelineDataDispatch, updateTestOutputPerProcessor]);
  const validateAndTestPipeline = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const {
      documents
    } = data;
    const {
      isSuccessful
    } = await handleTestPipeline({
      documents: documents,
      verbose: cachedVerbose
    });
    if (isSuccessful) {
      setActiveTab('output');
    }
  };
  const resetTestOutput = () => {
    testPipelineDataDispatch({
      type: 'reset'
    });
  };
  (0, _react.useEffect)(() => {
    if (cachedDocuments && activeTab === 'output') {
      handleTestPipeline({
        documents: cachedDocuments,
        verbose: cachedVerbose
      }, true);
    }
    // We only want to know on initial mount if
    // there are cached documents and we are on the output tab
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_test_pipeline_flyout.TestPipelineFlyout, {
    handleTestPipeline: handleTestPipeline,
    resetTestOutput: resetTestOutput,
    isRunningTest: isRunningTest,
    cachedVerbose: cachedVerbose,
    cachedDocuments: cachedDocuments,
    testOutput: testOutput,
    form: form,
    validateAndTestPipeline: validateAndTestPipeline,
    selectedTab: activeTab,
    setSelectedTab: setActiveTab,
    testingError: testingError,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  });
};
exports.TestPipelineFlyout = TestPipelineFlyout;