"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropZoneButton = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processors_tree/components/drop_zone_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const moveHereLabel = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dropZoneButton.moveHereToolTip', {
  defaultMessage: 'Move here'
});
const cannotMoveHereLabel = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dropZoneButton.unavailableToolTip', {
  defaultMessage: 'Cannot move here'
});
const dropZoneButtonHeight = 60;
const dropZoneButtonOffsetY = dropZoneButtonHeight * 0.5;
const useStyles = ({
  isVisible,
  isUnavailable,
  compressed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      position: relative;
      margin: 2px;
      visibility: hidden;
      background-color: transparent;
      height: 2px;
      ${isVisible && (0, _react2.css)`
        visibility: visible;
        &:hover {
          background-color: ${isUnavailable ? euiTheme.colors.mediumShade : euiTheme.colors.primary};
        }
      `}
    `,
    button: (0, _react2.css)`
      position: absolute;
      padding: 0;
      height: ${compressed ? dropZoneButtonOffsetY : dropZoneButtonHeight}px;
      margin-top: -${dropZoneButtonOffsetY}px;
      width: 100%;
      text-decoration: none !important;
      z-index: ${euiTheme.levels.flyout};
      ${isVisible && (0, _react2.css)`
        pointer-events: visible !important;
        &:hover {
          transform: none !important;
        }
      `}
    `
  };
};
const DropZoneButton = props => {
  const {
    onClick,
    isDisabled,
    isVisible,
    compressed
  } = props;
  const isUnavailable = isVisible && isDisabled;
  const styles = useStyles({
    isVisible,
    isUnavailable,
    compressed
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": props['data-test-subj'],
    css: styles.button,
    "aria-label": isUnavailable ? cannotMoveHereLabel : moveHereLabel
    // We artificially disable the button so that hover and pointer events are
    // still enabled
    ,
    onClick: isDisabled ? () => {} : onClick,
    iconType: "empty",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }));
};
exports.DropZoneButton = DropZoneButton;