"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Script = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/script.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */

  id: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.storedScriptIDFieldLabel', {
      defaultMessage: 'Stored script ID'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.storedScriptIDFieldHelpText', {
      defaultMessage: 'ID of the stored script to run.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.idRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  source: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.sourceFieldLabel', {
      defaultMessage: 'Source'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.sourceFieldHelpText', {
      defaultMessage: 'Inline script to run.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.sourceRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  /* Optional fields config */
  lang: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.langFieldLabel', {
      defaultMessage: 'Language (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.scriptForm.langFieldHelpText",
      defaultMessage: "Script language. Defaults to {lang}.",
      values: {
        lang: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 94,
            columnNumber: 17
          }
        }, 'painless')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    })
  },
  params: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.xJsonString,
    serializer: _shared.from.optionalXJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.paramsFieldLabel', {
      defaultMessage: 'Parameters'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.paramsFieldHelpText', {
      defaultMessage: 'Named parameters passed to the script as variables.'
    }),
    validations: [{
      validator: value => {
        if (value.value) {
          return (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.processorInvalidJsonError', {
            defaultMessage: 'Invalid JSON'
          }))(value);
        }
      }
    }]
  }
};
const Script = ({
  initialFieldValues
}) => {
  const [showId, setShowId] = (0, _react.useState)(() => !!(initialFieldValues !== null && initialFieldValues !== void 0 && initialFieldValues.id));
  const [scriptLanguage, setScriptLanguage] = (0, _react.useState)(_monaco.PainlessLang.ID);
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: 'fields.lang'
  });
  const suggestionProvider = _monaco.PainlessLang.getSuggestionProvider('processor_conditional');
  (0, _react.useEffect)(() => {
    const isPainlessLang = (fields === null || fields === void 0 ? void 0 : fields.lang) === 'painless' || (fields === null || fields === void 0 ? void 0 : fields.lang) === ''; // Scripting language defaults to painless if none specified
    setScriptLanguage(isPainlessLang ? _monaco.PainlessLang.ID : 'plaintext');
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.useScriptIdToggleLabel', {
      defaultMessage: 'Run a stored script'
    }),
    checked: showId,
    onChange: () => setShowId(v => !v),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  })), showId ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "fields.id",
    path: "fields.id",
    component: _shared_imports.Field,
    config: fieldsConfig.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.lang,
    path: "fields.lang",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "fields.source",
    path: "fields.source",
    component: _field_components.TextEditor,
    componentProps: {
      editorProps: {
        'data-test-subj': 'scriptSource',
        languageId: scriptLanguage,
        suggestionProvider: scriptLanguage === _monaco.PainlessLang.ID ? suggestionProvider : undefined,
        height: _shared.EDITOR_PX_HEIGHT.medium,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.sourceFieldAriaLabel', {
          defaultMessage: 'Source script JSON editor'
        }),
        options: {
          minimap: {
            enabled: false
          },
          lineNumbers: 'off'
        }
      }
    },
    config: fieldsConfig.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _field_components.XJsonEditor,
    componentProps: {
      editorProps: {
        'data-test-subj': 'paramsField',
        height: _shared.EDITOR_PX_HEIGHT.medium,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.scriptForm.paramsFieldAriaLabel', {
          defaultMessage: 'Parameters JSON editor'
        })
      }
    },
    config: fieldsConfig.params,
    path: "fields.params",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }));
};
exports.Script = Script;