"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditProcessorForm = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _context = require("../../context");
var _shared = require("../shared");
var _processor_settings_fields = require("./processor_settings_fields");
var _documentation_button = require("./documentation_button");
var _processor_output = require("./processor_output");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/edit_processor_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const updateButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.processorFormFlyout.updateButtonLabel', {
  defaultMessage: 'Update'
});
const cancelButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.processorFormFlyout.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const tabs = [{
  id: 'configuration',
  name: _i18n.i18n.translate('xpack.ingestPipelines.settingsFormOnFailureFlyout.configurationTabTitle', {
    defaultMessage: 'Configuration'
  })
}, {
  id: 'output',
  name: _i18n.i18n.translate('xpack.ingestPipelines.settingsFormOnFailureFlyout.outputTabTitle', {
    defaultMessage: 'Output'
  })
}];
const getFlyoutTitle = isOnFailure => {
  return isOnFailure ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.manageOnFailureTitle",
    defaultMessage: "Manage on-failure processor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.manageTitle",
    defaultMessage: "Manage processor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
};
const EditProcessorForm = ({
  getProcessor,
  form,
  isOnFailure,
  onOpen,
  esDocsBasePath,
  closeFlyout,
  handleSubmit,
  resetProcessors,
  buttonRef
}) => {
  const {
    testPipelineData,
    testPipelineDataDispatch
  } = (0, _context.useTestPipelineContext)();
  const {
    testOutputPerProcessor,
    config: {
      selectedDocumentIndex,
      documents
    },
    isExecutingPipeline
  } = testPipelineData;
  const processor = getProcessor();
  const processorOutput = processor && testOutputPerProcessor && testOutputPerProcessor[selectedDocumentIndex][processor.id];
  const updateSelectedDocument = index => {
    testPipelineDataDispatch({
      type: 'updateActiveDocument',
      payload: {
        config: {
          selectedDocumentIndex: index
        }
      }
    });
  };
  (0, _react.useEffect)(() => {
    onOpen();
  }, [] /* eslint-disable-line react-hooks/exhaustive-deps */);
  const [activeTab, setActiveTab] = (0, _react.useState)('configuration');
  let flyoutContent;
  if (activeTab === 'output') {
    flyoutContent = /*#__PURE__*/_react.default.createElement(_processor_output.ProcessorOutput, {
      processorOutput: processorOutput,
      documents: documents,
      selectedDocumentIndex: selectedDocumentIndex,
      updateSelectedDocument: updateSelectedDocument,
      isExecuting: isExecutingPipeline,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 7
      }
    });
  } else {
    flyoutContent = /*#__PURE__*/_react.default.createElement(_processor_settings_fields.ProcessorSettingsFields, {
      processor: processor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 21
      }
    });
  }
  const isFormDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    "data-test-subj": "editProcessorForm",
    form: form,
    onSubmit: handleSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    maxWidth: 720,
    onClose: () => {
      resetProcessors();
      closeFlyout();
    },
    outsideClickCloses: !isFormDirty,
    "aria-labelledby": flyoutTitleId,
    focusTrapProps: {
      returnFocus: triggerElement => {
        if (buttonRef !== null && buttonRef !== void 0 && buttonRef.current) {
          // Using setTimeout here to postpone focus until after the flyout has finished unmounting and cleaning up its focus traps.
          // Without this, the focus gets applied too early and it's overridden by the browser's default focus behavior.
          setTimeout(() => {
            var _buttonRef$current;
            (_buttonRef$current = buttonRef.current) === null || _buttonRef$current === void 0 ? void 0 : _buttonRef$current.focus();
          }, 0);
          return false;
        }
        return true;
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 19
    }
  }, getFlyoutTitle(isOnFailure))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, ({
    type
  }) => {
    const formDescriptor = (0, _shared.getProcessorDescriptor)(type);
    if (formDescriptor) {
      return /*#__PURE__*/_react.default.createElement(_documentation_button.DocumentationButton, {
        processorLabel: formDescriptor.label,
        docLink: formDescriptor.docLinkPath,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 23
        }
      });
    }
    return null;
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: async () => {
      // No need to do anything if user clicks the already active tab
      if (tab.id === activeTab) {
        return;
      }
      if (tab.id === 'output') {
        await handleSubmit(false);
      } else {
        form.reset({
          defaultValue: {
            fields: processor.options
          }
        });
      }
      setActiveTab(tab.id);
    },
    isSelected: tab.id === activeTab,
    key: tab.id,
    "data-test-subj": `${tab.id}Tab`,
    disabled: tab.id === 'output' && (Boolean(testOutputPerProcessor) === false || Boolean(processorOutput) === false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }), flyoutContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      resetProcessors();
      closeFlyout();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !form.isValid && form.isSubmitted || form.isSubmitting,
    "data-test-subj": "submitButton",
    onClick: async () => {
      if (activeTab === 'output') {
        return closeFlyout();
      }
      await handleSubmit();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 15
    }
  }, updateButtonLabel))))));
};
exports.EditProcessorForm = EditProcessorForm;