"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_timeline_chart_theme = require("../../../../hooks/use_timeline_chart_theme");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_kibana_ui_setting = require("../../../../hooks/use_kibana_ui_setting");
var _use_metrics_explorer_options = require("../hooks/use_metrics_explorer_options");
var _chart_context_menu = require("./chart_context_menu");
var _chart_title = require("./chart_title");
var _empty_chart = require("./empty_chart");
var _calculate_domain = require("./helpers/calculate_domain");
var _create_formatter_for_metric = require("./helpers/create_formatter_for_metric");
var _no_metrics = require("./no_metrics");
var _series_chart = require("./series_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsExplorerChart = ({
  options,
  chartOptions,
  series,
  title,
  onFilter,
  height = 200,
  width = '100%',
  timeRange,
  onTimeChange
}) => {
  const {
    services: {
      application: {
        capabilities: uiCapabilities
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const {
    metrics
  } = options;
  const [dateFormat] = (0, _use_kibana_ui_setting.useKibanaUiSetting)('dateFormat');
  const handleTimeChange = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [from, to] = x;
    onTimeChange((0, _moment.default)(from).toISOString(), (0, _moment.default)(to).toISOString());
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    const firstRow = (0, _lodash.first)(series.rows);
    const lastRow = (0, _lodash.last)(series.rows);
    return firstRow && lastRow ? (0, _charts.niceTimeFormatter)([firstRow.timestamp, lastRow.timestamp]) : value => `${value}`;
  }, [series.rows]);
  const tooltipProps = {
    headerFormatter: (0, _react.useCallback)(({
      value
    }) => (0, _moment.default)(value).format(dateFormat || 'Y-MM-DD HH:mm:ss.SSS'), [dateFormat])
  };
  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const yAxisFormater = (0, _react.useCallback)((0, _create_formatter_for_metric.createFormatterForMetric)((0, _lodash.first)(metrics)), [options]);
  const dataDomain = (0, _calculate_domain.calculateDomain)(series, metrics, chartOptions.stack);
  const domain = chartOptions.yAxisMode === _use_metrics_explorer_options.MetricsExplorerYAxisMode.fromZero ? {
    ...dataDomain,
    min: 0
  } : dataDomain;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: 24
    },
    "data-test-subj": "metricsExplorer-chart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, options.groupBy ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ChartTitleContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: title,
    anchorClassName: "metricsExplorerTitleAnchor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_title.ChartTitle, {
    series: series,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_context_menu.MetricsExplorerChartContextMenu, {
    timeRange: timeRange,
    options: options,
    chartOptions: chartOptions,
    series: series,
    onFilter: onFilter,
    uiCapabilities: uiCapabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_context_menu.MetricsExplorerChartContextMenu, {
    options: options,
    chartOptions: chartOptions,
    series: series,
    timeRange: timeRange,
    uiCapabilities: uiCapabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "metricsExplorerChart",
    style: {
      height,
      width
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, metrics.length && series.rows.length > 0 ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, metrics.map((metric, id) => /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: chartOptions.type,
    key: id,
    metric: metric,
    id: id,
    series: series,
    stack: chartOptions.stack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormater,
    domain: domain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, tooltipProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: handleTimeChange,
    baseTheme: chartTheme.baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })) : options.metrics.length > 0 ? /*#__PURE__*/_react.default.createElement(_empty_chart.MetricsExplorerEmptyChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_no_metrics.MetricsExplorerNoMetrics, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })));
};
exports.MetricsExplorerChart = MetricsExplorerChart;
const ChartTitleContainer = _styled.default.div`
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  text-align: left;
  flex: 1 1 auto;
  margin: 12px;
`;