"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryTimeRangeMetadataProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_time_range_metadata = require("../../../../hooks/use_time_range_metadata");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/providers/inventory_timerange_metadata_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InventoryTimeRangeMetadataProvider = ({
  children
}) => {
  const {
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    filterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    currentTimeRange
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    start,
    end
  } = (0, _react.useMemo)(() => {
    return {
      start: new Date(currentTimeRange.from).toISOString(),
      end: new Date(currentTimeRange.to).toISOString()
    };
  }, [currentTimeRange.from, currentTimeRange.to]);
  if (nodeType !== 'host') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_use_time_range_metadata.TimeRangeMetadataProvider, {
    dataSource: nodeType,
    kuery: filterQuery.query,
    start: start,
    end: end,
    isInventoryView: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, children);
};
exports.InventoryTimeRangeMetadataProvider = InventoryTimeRangeMetadataProvider;