"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfraMLModuleConfiguration = exports.isJobConfigurationOutdated = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfraMLModuleConfiguration = ({
  moduleDescriptor,
  sourceConfiguration
}) => {
  const getIsJobConfigurationOutdated = (0, _react.useMemo)(() => isJobConfigurationOutdated(moduleDescriptor, sourceConfiguration), [sourceConfiguration, moduleDescriptor]);
  return {
    getIsJobConfigurationOutdated
  };
};
exports.useInfraMLModuleConfiguration = useInfraMLModuleConfiguration;
const isJobConfigurationOutdated = ({
  bucketSpan
}, currentSourceConfiguration) => jobSummary => {
  if (!jobSummary.fullJob || !jobSummary.fullJob.custom_settings) {
    return false;
  }
  const jobConfiguration = jobSummary.fullJob.custom_settings.metrics_source_config;
  return !(jobConfiguration && jobConfiguration.bucketSpan === bucketSpan && jobConfiguration.indexPattern && isSubset(new Set(jobConfiguration.indexPattern.split(',')), new Set(currentSourceConfiguration.indices)));
};
exports.isJobConfigurationOutdated = isJobConfigurationOutdated;
const isSubset = (subset, superset) => {
  return Array.from(subset).every(subsetElement => superset.has(subsetElement));
};