"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisModuleList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../../common/log_analysis");
var _log_analysis2 = require("../../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../../containers/logs/log_analysis/modules/log_entry_rate");
var _module_list_card = require("./module_list_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/setup_flyout/module_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogAnalysisModuleList = ({
  onViewModuleSetup
}) => {
  const {
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis2.useLogAnalysisCapabilitiesContext)();
  const {
    setupStatus: logEntryRateSetupStatus,
    jobIds: logEntryRateJobIds
  } = (0, _log_entry_rate.useLogEntryRateModuleContext)();
  const {
    setupStatus: logEntryCategoriesSetupStatus,
    jobIds: logEntryCategoriesJobIds
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const viewLogEntryRateSetupFlyout = (0, _react.useCallback)(() => {
    onViewModuleSetup('logs_ui_analysis');
  }, [onViewModuleSetup]);
  const viewLogEntryCategoriesSetupFlyout = (0, _react.useCallback)(() => {
    onViewModuleSetup('logs_ui_categories');
  }, [onViewModuleSetup]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_module_list_card.LogAnalysisModuleListCard, {
    jobId: logEntryRateJobIds[_log_analysis.logEntryRateJobType],
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    moduleDescription: _log_entry_rate.logEntryRateModule.moduleDescription,
    moduleName: _log_entry_rate.logEntryRateModule.moduleName,
    moduleStatus: logEntryRateSetupStatus,
    onViewSetup: viewLogEntryRateSetupFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_module_list_card.LogAnalysisModuleListCard, {
    jobId: logEntryCategoriesJobIds[_log_analysis.logEntryCategoriesJobType],
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    moduleDescription: _log_entry_categories.logEntryCategoriesModule.moduleDescription,
    moduleName: _log_entry_categories.logEntryCategoriesModule.moduleName,
    moduleStatus: logEntryCategoriesSetupStatus,
    onViewSetup: viewLogEntryCategoriesSetupFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }))));
};
exports.LogAnalysisModuleList = LogAnalysisModuleList;