"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostKpiCharts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kpi = require("./kpi");
var _use_host_metrics_charts = require("../../hooks/use_host_metrics_charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/kpis/host_kpi_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HostKpiCharts = ({
  dateRange,
  dataView,
  filters,
  getSubtitle,
  query,
  lastReloadRequestTime,
  loading = false,
  schema
}) => {
  const charts = (0, _use_host_metrics_charts.useHostKpiCharts)({
    indexPattern: dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern(),
    getSubtitle,
    schema
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    filters: filters,
    query: query,
    lastReloadRequestTime: lastReloadRequestTime,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })))));
};
exports.HostKpiCharts = HostKpiCharts;