"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsertInventoryViewError = exports.FetchInventoryViewError = exports.DeleteInventoryViewError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class FetchInventoryViewError extends Error {
  constructor(message, cause) {
    super(message);
    this.cause = cause;
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'FetchInventoryViewError';
  }
}
exports.FetchInventoryViewError = FetchInventoryViewError;
class UpsertInventoryViewError extends Error {
  constructor(message, cause) {
    super(message);
    this.cause = cause;
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'UpsertInventoryViewError';
  }
}
exports.UpsertInventoryViewError = UpsertInventoryViewError;
class DeleteInventoryViewError extends Error {
  constructor(message, cause) {
    super(message);
    this.cause = cause;
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'DeleteInventoryViewError';
  }
}
exports.DeleteInventoryViewError = DeleteInventoryViewError;