"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReasonToolCall = createReasonToolCall;
exports.createReasonToolCallResponse = createReasonToolCallResponse;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REASON_INSTRUCTIONS = `Reply in plain text, reflecting on previous steps and the task ahead. You're not allowed to call any tools in this turn - hand control back to the orchestrator. Start your reply with <<<BEGIN_INTERNAL>>>.`;
function createReasonToolCall() {
  const toolCallId = (0, _inferenceCommon.generateFakeToolCallId)();
  return [{
    role: _inferenceCommon.MessageRole.Assistant,
    content: '',
    toolCalls: [{
      function: {
        name: 'reason',
        arguments: {}
      },
      toolCallId
    }]
  }, createReasonToolCallResponse(toolCallId)];
}
function createReasonToolCallResponse(toolCallId) {
  return {
    role: _inferenceCommon.MessageRole.Tool,
    toolCallId,
    name: 'reason',
    response: {
      acknowledged: true,
      instructions: REASON_INSTRUCTIONS
    }
  };
}