"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInferenceRestClient = createInferenceRestClient;
var _inferenceCommon = require("@kbn/inference-common");
var _chat_complete = require("./chat_complete");
var _prompt = require("./prompt");
var _output = require("../output");
var _bind_client = require("../inference_client/bind_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createInferenceRestClient({
  fetch,
  signal
}) {
  const chatComplete = (0, _chat_complete.createChatCompleteRestApi)({
    fetch,
    signal
  });
  const client = {
    bindTo: options => {
      return (0, _bind_client.bindClient)(client, options);
    },
    chatComplete,
    prompt: (0, _prompt.createPromptRestApi)({
      fetch,
      signal
    }),
    output: (0, _output.createOutputApi)(chatComplete),
    getConnectorById: async connectorId => {
      return fetch('/internal/inference/connectors', {
        method: 'GET',
        signal
      }).then(({
        connectors
      }) => {
        const matchingConnector = connectors.find(connector => connector.connectorId === connectorId);
        if (!matchingConnector) {
          throw (0, _inferenceCommon.createInferenceRequestError)(`No connector found for id '${connectorId}'`, 404);
        }
        return matchingConnector;
      });
    }
  };
  return client;
}