"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_index_errors = require("../../../../hooks/use_index_errors");
var _reset_index_url_params = require("./reset_index_url_params");
var _render_badges = require("../../../../lib/render_badges");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../services/routing");
var _app_context = require("../../../../app_context");
var _discover_link = require("../../../../lib/discover_link");
var _manage_index_button = require("./manage_index_button");
var _details_page_overview = require("./details_page_overview");
var _details_page_mappings = require("./details_page_mappings");
var _details_page_settings = require("./details_page_settings");
var _details_page_stats = require("./details_page_stats");
var _details_page_tab = require("./details_page_tab");
var _index_error_callout = require("./index_error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultTabs = [{
  id: _constants.IndexDetailsSection.Overview,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTitle', {
    defaultMessage: 'Overview'
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_overview.DetailsPageOverview, {
    indexDetails: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 38
    }
  }),
  order: 10
}, {
  id: _constants.IndexDetailsSection.Mappings,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappingsTitle', {
    defaultMessage: 'Mappings'
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_mappings.DetailsPageMappings, {
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 38
    }
  }),
  order: 20
}, {
  id: _constants.IndexDetailsSection.Settings,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.settingsTitle', {
    defaultMessage: 'Settings'
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_settings.DetailsPageSettings, {
    indexName: index.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 38
    }
  }),
  order: 30
}];
const statsTab = {
  id: _constants.IndexDetailsSection.Stats,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.statsTitle', {
    defaultMessage: 'Statistics'
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_stats.DetailsPageStats, {
    indexName: index.name,
    isIndexOpen: index.status === _constants.INDEX_OPEN,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }),
  order: 40
};
const DetailsPageContent = ({
  index,
  tab,
  history,
  search,
  fetchIndexDetails,
  navigateToIndicesList
}) => {
  var _capabilities$ml;
  const {
    core: {
      application: {
        capabilities
      }
    },
    config: {
      enableIndexStats
    },
    plugins: {
      console: consolePlugin,
      ml
    },
    services: {
      extensionsService
    }
  } = (0, _app_context.useAppContext)();
  const hasMLPermissions = capabilities !== null && capabilities !== void 0 && (_capabilities$ml = capabilities.ml) !== null && _capabilities$ml !== void 0 && _capabilities$ml.canGetTrainedModels ? true : false;
  const indexErrors = (0, _use_index_errors.useIndexErrors)(index, ml, hasMLPermissions);
  const tabs = (0, _react.useMemo)(() => {
    const sortedTabs = [...defaultTabs];
    if (enableIndexStats) {
      sortedTabs.push(statsTab);
    }
    extensionsService.indexDetailsTabs.forEach(dynamicTab => {
      if (!dynamicTab.shouldRenderTab || dynamicTab.shouldRenderTab({
        index
      })) {
        sortedTabs.push(dynamicTab);
      }
    });
    sortedTabs.sort((tabA, tabB) => {
      return tabA.order - tabB.order;
    });
    return sortedTabs;
  }, [enableIndexStats, extensionsService.indexDetailsTabs, index]);
  const onSectionChange = (0, _react.useCallback)(newSection => {
    return history.push((0, _routing.getIndexDetailsLink)(index.name, (0, _reset_index_url_params.resetIndexUrlParams)(search), newSection));
  }, [history, index.name, search]);
  const headerTabs = (0, _react.useMemo)(() => {
    return tabs.map(tabConfig => ({
      onClick: () => onSectionChange(tabConfig.id),
      isSelected: tabConfig.id === tab,
      key: tabConfig.id,
      'data-test-subj': `indexDetailsTab-${tabConfig.id}`,
      label: tabConfig.name
    }));
  }, [tabs, tab, onSectionChange]);
  const pageTitle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.name, (0, _render_badges.renderBadges)(index, extensionsService));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "indexDetailsBackToIndicesButton",
    color: "text",
    iconType: "arrowLeft",
    onClick: navigateToIndicesList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.backToIndicesButtonLabel",
    defaultMessage: "Back to indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "indexDetailsHeader",
    pageTitle: pageTitle,
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_discover_link.DiscoverLink, {
      indexName: index.name,
      asButton: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_manage_index_button.ManageIndexButton, {
      index: index,
      reloadIndexDetails: fetchIndexDetails,
      navigateToIndicesList: navigateToIndicesList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    })],
    rightSideGroupProps: {
      wrap: false
    },
    responsive: "reverse",
    tabs: headerTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, indexErrors.length > 0 ? /*#__PURE__*/_react.default.createElement(_index_error_callout.IndexErrorCallout, {
    errors: indexErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 35
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `indexDetailsContent`,
    css: (0, _react2.css)`
          height: 100%;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_details_page_tab.DetailsPageTab, {
    tabs: tabs,
    tab: tab,
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  })), consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 43
    }
  }) : null);
};
exports.DetailsPageContent = DetailsPageContent;