"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _app_context = require("../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/lib/discover_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DiscoverLink = ({
  indexName,
  asButton = false
}) => {
  const {
    url
  } = (0, _app_context.useAppContext)();
  const discoverLocator = url === null || url === void 0 ? void 0 : url.locators.get('DISCOVER_APP_LOCATOR');
  if (!discoverLocator) {
    return null;
  }
  const onClick = async () => {
    await discoverLocator.navigate({
      dataViewSpec: {
        title: indexName
      }
    });
  };
  let link = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onClick,
    display: "empty",
    size: "xs",
    iconType: "discoverApp",
    "aria-label": "Discover",
    "data-test-subj": "discoverIconLink",
    css: {
      margin: '0 0.3em'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
  if (asButton) {
    link = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: onClick,
      iconType: "discoverApp",
      "data-test-subj": "discoverButtonLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.goToDiscover.discoverIndexButtonLabel",
      defaultMessage: "Discover index",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.idxMgmt.goToDiscover.showIndexToolTip', {
      defaultMessage: 'Show {indexName} in Discover',
      values: {
        indexName
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, link);
};
exports.DiscoverLink = DiscoverLink;