"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuperSelectOption = exports.TYPE_ONLY_ALLOWED_AT_ROOT_LEVEL = exports.TYPE_NOT_ALLOWED_MULTIFIELD = exports.PARAMETERS_OPTIONS = exports.FIELD_TYPES_OPTIONS = exports.ALL_DATE_FORMAT_OPTIONS = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _field_options_i18n = require("./field_options_i18n");
var _default_values = require("./default_values");
var _data_types_definition = require("./data_types_definition");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/constants/field_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TYPE_ONLY_ALLOWED_AT_ROOT_LEVEL = exports.TYPE_ONLY_ALLOWED_AT_ROOT_LEVEL = ['join'];
const TYPE_NOT_ALLOWED_MULTIFIELD = exports.TYPE_NOT_ALLOWED_MULTIFIELD = [...TYPE_ONLY_ALLOWED_AT_ROOT_LEVEL, 'object', 'nested', 'alias'];
const FIELD_TYPES_OPTIONS = exports.FIELD_TYPES_OPTIONS = Object.entries(_data_types_definition.MAIN_DATA_TYPE_DEFINITION).map(([dataType, {
  label
}]) => ({
  value: dataType,
  label,
  'data-test-subj': `fieldTypesOptions-${dataType}`
}));
const getSuperSelectOption = (title, description) => ({
  inputDisplay: title,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, description)))
});
exports.getSuperSelectOption = getSuperSelectOption;
const getOptionTexts = option => getSuperSelectOption(_field_options_i18n.FIELD_OPTIONS_TEXTS[option].title, _field_options_i18n.FIELD_OPTIONS_TEXTS[option].description);
const PARAMETERS_OPTIONS = exports.PARAMETERS_OPTIONS = {
  index_options: [{
    value: 'docs',
    ...getOptionTexts('indexOptions.docs')
  }, {
    value: 'freqs',
    ...getOptionTexts('indexOptions.freqs')
  }, {
    value: 'positions',
    ...getOptionTexts('indexOptions.positions')
  }, {
    value: 'offsets',
    ...getOptionTexts('indexOptions.offsets')
  }],
  index_options_flattened: [{
    value: 'docs',
    ...getOptionTexts('indexOptions.docs')
  }, {
    value: 'freqs',
    ...getOptionTexts('indexOptions.freqs')
  }],
  index_options_keyword: [{
    value: 'docs',
    ...getOptionTexts('indexOptions.docs')
  }, {
    value: 'freqs',
    ...getOptionTexts('indexOptions.freqs')
  }],
  analyzer: [{
    value: _default_values.INDEX_DEFAULT,
    ...getOptionTexts('analyzer.indexDefault')
  }, {
    value: _default_values.STANDARD,
    ...getOptionTexts('analyzer.standard')
  }, {
    value: 'simple',
    ...getOptionTexts('analyzer.simple')
  }, {
    value: 'whitespace',
    ...getOptionTexts('analyzer.whitespace')
  }, {
    value: 'stop',
    ...getOptionTexts('analyzer.stop')
  }, {
    value: 'keyword',
    ...getOptionTexts('analyzer.keyword')
  }, {
    value: 'pattern',
    ...getOptionTexts('analyzer.pattern')
  }, {
    value: 'fingerprint',
    ...getOptionTexts('analyzer.fingerprint')
  }, {
    value: 'language',
    ...getOptionTexts('analyzer.language')
  }],
  languageAnalyzer: Object.entries(_field_options_i18n.LANGUAGE_OPTIONS_TEXT).map(([value, text]) => ({
    value,
    text
  })),
  similarity: [{
    value: 'BM25',
    ...getOptionTexts('similarity.bm25')
  }, {
    value: 'boolean',
    ...getOptionTexts('similarity.boolean')
  }],
  term_vector: [{
    value: 'no',
    ...getOptionTexts('termVector.no')
  }, {
    value: 'yes',
    ...getOptionTexts('termVector.yes')
  }, {
    value: 'with_positions',
    ...getOptionTexts('termVector.withPositions')
  }, {
    value: 'with_offsets',
    ...getOptionTexts('termVector.withOffsets')
  }, {
    value: 'with_positions_offsets',
    ...getOptionTexts('termVector.withPositionsOffsets')
  }, {
    value: 'with_positions_payloads',
    ...getOptionTexts('termVector.withPositionsPayloads')
  }, {
    value: 'with_positions_offsets_payloads',
    ...getOptionTexts('termVector.withPositionsOffsetsPayloads')
  }],
  orientation: [{
    value: 'ccw',
    ...getOptionTexts('orientation.counterclockwise')
  }, {
    value: 'cw',
    ...getOptionTexts('orientation.clockwise')
  }]
};
const DATE_FORMATS = [{
  label: 'epoch_millis'
}, {
  label: 'epoch_second'
}, {
  label: 'date_optional_time',
  strict: true
}, {
  label: 'basic_date'
}, {
  label: 'basic_date_time'
}, {
  label: 'basic_date_time_no_millis'
}, {
  label: 'basic_ordinal_date'
}, {
  label: 'basic_ordinal_date_time'
}, {
  label: 'basic_ordinal_date_time_no_millis'
}, {
  label: 'basic_time'
}, {
  label: 'basic_time_no_millis'
}, {
  label: 'basic_t_time'
}, {
  label: 'basic_t_time_no_millis'
}, {
  label: 'basic_week_date',
  strict: true
}, {
  label: 'basic_week_date_time',
  strict: true
}, {
  label: 'basic_week_date_time_no_millis',
  strict: true
}, {
  label: 'date',
  strict: true
}, {
  label: 'date_hour',
  strict: true
}, {
  label: 'date_hour_minute',
  strict: true
}, {
  label: 'date_hour_minute_second',
  strict: true
}, {
  label: 'date_hour_minute_second_fraction',
  strict: true
}, {
  label: 'date_hour_minute_second_millis',
  strict: true
}, {
  label: 'date_time',
  strict: true
}, {
  label: 'date_time_no_millis',
  strict: true
}, {
  label: 'hour',
  strict: true
}, {
  label: 'hour_minute ',
  strict: true
}, {
  label: 'hour_minute_second',
  strict: true
}, {
  label: 'hour_minute_second_fraction',
  strict: true
}, {
  label: 'hour_minute_second_millis',
  strict: true
}, {
  label: 'ordinal_date',
  strict: true
}, {
  label: 'ordinal_date_time',
  strict: true
}, {
  label: 'ordinal_date_time_no_millis',
  strict: true
}, {
  label: 'time',
  strict: true
}, {
  label: 'time_no_millis',
  strict: true
}, {
  label: 't_time',
  strict: true
}, {
  label: 't_time_no_millis',
  strict: true
}, {
  label: 'week_date',
  strict: true
}, {
  label: 'week_date_time',
  strict: true
}, {
  label: 'week_date_time_no_millis',
  strict: true
}, {
  label: 'weekyear',
  strict: true
}, {
  label: 'weekyear_week',
  strict: true
}, {
  label: 'weekyear_week_day',
  strict: true
}, {
  label: 'year',
  strict: true
}, {
  label: 'year_month',
  strict: true
}, {
  label: 'year_month_day',
  strict: true
}];
const STRICT_DATE_FORMAT_OPTIONS = DATE_FORMATS.filter(format => format.strict).map(({
  label
}) => ({
  label: `strict_${label}`
}));
const DATE_FORMAT_OPTIONS = DATE_FORMATS.map(({
  label
}) => ({
  label
}));
const ALL_DATE_FORMAT_OPTIONS = exports.ALL_DATE_FORMAT_OPTIONS = [...DATE_FORMAT_OPTIONS, ...STRICT_DATE_FORMAT_OPTIONS];