"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimilarityParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _edit_field = require("../fields/edit_field");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/similarity_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SimilarityParameter = ({
  defaultToggleValue
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.setSimilarityFieldTitle', {
    defaultMessage: 'Set similarity'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.setSimilarityFieldDescription', {
    defaultMessage: 'The scoring algorithm or similarity to use.'
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.similarityDocLinkText', {
      defaultMessage: 'Similarity documentation'
    }),
    href: _documentation.documentationService.getSimilarityLink()
  },
  defaultToggleValue: defaultToggleValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "similarity",
  config: (0, _lib.getFieldConfig)('similarity'),
  component: _shared_imports.Field,
  componentProps: {
    euiFieldProps: {
      options: _constants.PARAMETERS_OPTIONS.similarity
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
}));
exports.SimilarityParameter = SimilarityParameter;