"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyJsonFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _i18n_texts = require("../i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/policy_json_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Ensure that the JSON we get from the from has phases in the correct order.
 */
const prettifyFormJson = policy => {
  return {
    phases: {
      hot: policy.phases.hot,
      warm: policy.phases.warm,
      cold: policy.phases.cold,
      frozen: policy.phases.frozen,
      delete: policy.phases.delete
    },
    deprecated: policy === null || policy === void 0 ? void 0 : policy.deprecated,
    _meta: policy._meta
  };
};
const PolicyJsonFlyout = ({
  policyName,
  close
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();

  /**
   * policy === undefined: we are checking validity
   * policy === null: we have determined the policy is invalid
   * policy === {@link PolicyJson} we have determined the policy is valid
   */
  const [policyJson, setPolicyJson] = (0, _react.useState)(undefined);
  const {
    validate: validateForm,
    getErrors
  } = (0, _shared_imports.useFormContext)();
  const [, getFormData] = (0, _shared_imports.useFormData)();
  const updatePolicy = (0, _react.useCallback)(async () => {
    setPolicyJson(undefined);
    const isFormValid = await validateForm();
    const errorMessages = getErrors();
    const isOnlyMissingPolicyName = errorMessages.length === 1 && errorMessages[0] === _i18n_texts.i18nTexts.editPolicy.errors.policyNameRequiredMessage;
    if (isFormValid || isOnlyMissingPolicyName) {
      setPolicyJson(prettifyFormJson(getFormData()));
    } else {
      setPolicyJson(null);
    }
  }, [setPolicyJson, getFormData, validateForm, getErrors]);
  (0, _react.useEffect)(() => {
    updatePolicy();
  }, [updatePolicy]);
  let content;
  switch (policyJson) {
    case undefined:
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 17
        }
      });
      break;
    case null:
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "policyRequestInvalidAlert",
        iconType: "warning",
        color: "danger",
        title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyJsonFlyout.validationErrorCallout.title', {
          defaultMessage: 'Invalid policy'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyJsonFlyout.validationErrorCallout.body', {
        defaultMessage: 'To view the JSON for this policy address all validation errors.'
      }));
      break;
    default:
      const json = JSON.stringify({
        policy: {
          ...policyJson
        }
      }, null, 2);
      const endpoint = `PUT _ilm/policy/${policyName || '<policyName>'}`;
      const request = `${endpoint}\n${json}`;
      content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyJsonFlyout.descriptionText",
        defaultMessage: "This Elasticsearch request will create or update this index lifecycle policy.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json",
        isCopyable: true,
        "data-test-subj": "policyRequestJson",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 11
        }
      }, request));
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 480,
    onClose: close,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, policyName ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyJsonFlyout.namedTitle",
    defaultMessage: "Request for ''{policyName}''",
    values: {
      policyName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyJsonFlyout.unnamedTitle",
    defaultMessage: "Request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: close,
    flush: "left",
    "data-test-subj": "policyRequestClose",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyJsonFlyout.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }))));
};
exports.PolicyJsonFlyout = PolicyJsonFlyout;