"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnitField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _form = require("../../../form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/unit_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UnitField = ({
  path,
  options,
  euiFieldProps
}) => {
  const [open, setOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_form.UseField, {
    key: path,
    path: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, field => {
    var _options$find$text, _options$find;
    const onSelect = option => {
      field.setValue(option);
      setOpen(false);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        color: "text",
        iconSide: "right",
        iconType: "arrowDown",
        onClick: () => setOpen(x => !x),
        "data-test-subj": "show-filters-button",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 15
        }
      }, (_options$find$text = (_options$find = options.find(x => x.value === field.value)) === null || _options$find === void 0 ? void 0 : _options$find.text) !== null && _options$find$text !== void 0 ? _options$find$text : `${field.value}`),
      ownFocus: true,
      panelPaddingSize: "none",
      isOpen: open,
      closePopover: () => setOpen(false)
    }, euiFieldProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      singleSelection: "always",
      listProps: {
        onFocusBadge: false,
        style: {
          minWidth: 130
        }
      },
      options: options.map(item => ({
        key: item.value,
        label: item.text,
        checked: field.value === item.value ? 'on' : undefined,
        'data-test-subj': `filter-option-${item.value}`
      })),
      onChange: (newOptions, event, changedOption) => {
        if (changedOption) {
          onSelect(changedOption.key);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, list => list));
  });
};
exports.UnitField = UnitField;