"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxIndexSizeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _form = require("../../../../form");
var _constants = require("../../../../constants");
var _unit_field = require("../../shared_fields/unit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/hot_phase/components/max_index_size_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  deprecationMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumIndexSizeDeprecationMessage', {
    defaultMessage: 'Maximum index size is deprecated and will be removed in a future version. Use maximum primary shard size instead.'
  }),
  maxSizeUnit: {
    ariaLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumIndexSizeUnitsAriaLabel', {
      defaultMessage: 'Maximum index size units'
    })
  }
};
const MaxIndexSizeField = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: _constants.ROLLOVER_FORM_PATHS.maxSize,
    component: _shared_imports.NumericField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'hot-selectedMaxSizeStored',
        min: 1,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "warning",
          "aria-label": i18nTexts.deprecationMessage,
          content: i18nTexts.deprecationMessage,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 17
          }
        }),
        append: /*#__PURE__*/_react.default.createElement(_unit_field.UnitField, {
          path: "_meta.hot.customRollover.maxStorageSizeUnit",
          options: _constants.byteSizeUnits,
          euiFieldProps: {
            'data-test-subj': 'hot-selectedMaxSizeStoredUnits',
            'aria-label': i18nTexts.maxSizeUnit.ariaLabel
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 17
          }
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  })));
};
exports.MaxIndexSizeField = MaxIndexSizeField;