"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VennDiagram = VennDiagram;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _vennjs = require("./vennjs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/venn_diagram/venn_diagram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getRadius(area) {
  return Math.sqrt(area / Math.PI);
}
function VennDiagram({
  leftValue,
  rightValue,
  overlap
}) {
  const leftRadius = getRadius(leftValue);
  const rightRadius = getRadius(rightValue);
  const maxRadius = Math.max(leftRadius, rightRadius);
  const imageHeight = maxRadius * 2;
  const imageWidth = maxRadius * 4;
  const leftCenter = leftRadius;
  const rightCenter = leftCenter + (0, _vennjs.distanceFromIntersectArea)(leftRadius, rightRadius, overlap);

  // blank width is what's left after the right venn circle - it is used as padding
  const blankWidth = imageWidth - (rightCenter + rightRadius);
  const padding = blankWidth / 2;
  const viewBoxDims = `0 0 ${imageWidth} ${imageHeight}`;
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: 100,
    height: 60,
    viewBox: viewBoxDims,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("circle", {
    cx: leftCenter + padding,
    cy: maxRadius,
    r: leftRadius,
    className: "gphVennDiagram__left",
    css: styles.left,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("circle", {
    cx: rightCenter + padding,
    cy: maxRadius,
    r: rightRadius,
    className: "gphVennDiagram__right",
    css: styles.right,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))));
}
const styles = {
  left: ({
    euiTheme
  }) => (0, _react2.css)`
      fill: ${euiTheme.colors.danger};
      fill-opacity: 0.5;
    `,
  right: ({
    euiTheme
  }) => (0, _react2.css)`
    fill: ${euiTheme.colors.primary};
    fill-opacity: 0.5;
  `
};