"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsForm = AdvancedSettingsForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/settings/advanced_settings_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Helper type to get all keys of an interface
// that are of type number.
// Used to parameterize the number updater function
// to make it impossible to pass in non-number keys

function AdvancedSettingsForm({
  advancedSettings,
  updateSettings,
  allFields
}) {
  // keep a local state during changes
  const [formState, updateFormState] = (0, _react.useState)({
    ...advancedSettings
  });

  // useEffect update localState only based on the main store
  (0, _react.useEffect)(() => {
    updateFormState(advancedSettings);
  }, [updateFormState, advancedSettings]);
  function updateSetting(key, value) {
    updateSettings({
      ...advancedSettings,
      [key]: value
    });
  }
  function getNumberUpdater(key) {
    return function ({
      target: {
        valueAsNumber,
        value
      }
    }) {
      // if the value is valid, then update the central store, otherwise only the local store
      if (Number.isNaN(valueAsNumber)) {
        // localstate update
        return updateFormState({
          ...formState,
          [key]: value
        });
      }
      // do not worry about local store here, the useEffect will pick that up and sync it
      updateSetting(key, valueAsNumber);
    };
  }
  return /*#__PURE__*/_react.default.createElement("form", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.sampleSizeInputHelpText', {
      defaultMessage: 'Terms are identified from samples of the most relevant documents. Bigger samples are not necessarily better—they can be slower and less relevant.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.sampleSizeInputLabel', {
      defaultMessage: 'Sample size'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.sampleSize,
    onChange: getNumberUpdater('sampleSize'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.significantLinksCheckboxHelpText', {
      defaultMessage: 'Identify terms that are significant rather than popular.'
    }),
    label: "",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.significantLinksCheckboxLabel', {
      defaultMessage: 'Significant links'
    }),
    id: "graphSignificance",
    checked: formState.useSignificance,
    onChange: ({
      target: {
        checked
      }
    }) => updateSetting('useSignificance', checked),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.certaintyInputHelpText', {
      defaultMessage: 'The minimum number of documents before introducing a related term.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.certaintyInputLabel', {
      defaultMessage: 'Certainty'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.minDocCount,
    onChange: getNumberUpdater('minDocCount'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputHelpText1', {
      defaultMessage: 'To avoid dominating samples with a single voice, select a field to help identify the source of bias.'
    }), ' ', /*#__PURE__*/_react.default.createElement("em", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputHelpText2', {
      defaultMessage: 'This must be a single-term field, or searches will be rejected.'
    }))),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputLabel', {
      defaultMessage: 'Diversity field'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputOptionLabel', {
      defaultMessage: 'No diversification'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: allFields.map(field => ({
      label: field.name,
      value: field
    })),
    selectedOptions: formState.sampleDiversityField ? [{
      label: formState.sampleDiversityField.name,
      value: formState.sampleDiversityField
    }] : [],
    onChange: choices => {
      updateSetting('sampleDiversityField', choices.length === 1 ? choices[0].value : undefined);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), formState.sampleDiversityField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputHelpText', {
      defaultMessage: 'Max number of documents in a sample that can contain the same value for the'
    }), ' ', /*#__PURE__*/_react.default.createElement("em", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, formState.sampleDiversityField.name), ' ', _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputHelpText.fieldText', {
      defaultMessage: 'field'
    })),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputLabel', {
      defaultMessage: 'Max docs per field'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.maxValuesPerDoc,
    onChange: getNumberUpdater('maxValuesPerDoc'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutInputHelpText', {
      defaultMessage: 'The maximum number of milliseconds that a request can run.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutInputLabel', {
      defaultMessage: 'Timeout'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.timeoutMillis,
    onChange: getNumberUpdater('timeoutMillis'),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutUnit', {
      defaultMessage: 'ms'
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  })));
}