"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPackagePoliciesCountByPackageName = getPackagePoliciesCountByPackageName;
var _package_policy = require("../package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getPackagePoliciesCountByPackageName(soClient) {
  var _res$aggregations$cou, _res$aggregations;
  const savedObjectType = await (0, _package_policy.getPackagePolicySavedObjectType)();
  const res = await soClient.find({
    type: savedObjectType,
    perPage: 0,
    aggs: {
      count_by_package_name: {
        terms: {
          field: `${savedObjectType}.attributes.package.name`
        }
      }
    }
  });
  return (_res$aggregations$cou = (_res$aggregations = res.aggregations) === null || _res$aggregations === void 0 ? void 0 : _res$aggregations.count_by_package_name.buckets.reduce((acc, bucket) => {
    acc[bucket.key] = bucket.doc_count;
    return acc;
  }, {})) !== null && _res$aggregations$cou !== void 0 ? _res$aggregations$cou : {};
}