"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewEnrollmentTokenModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/new_enrollment_key_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function validatePolicyId(value) {
  if (value === '') {
    return [_i18n.i18n.translate('xpack.fleet.newEnrollmentKeyForm.policyIdRequireErrorMessage', {
      defaultMessage: 'Policy is required'
    })];
  }
}
function useCreateApiKeyForm(policyIdDefaultValue, onSuccess, onError) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const apiKeyNameInput = (0, _hooks.useInput)('');
  const policyIdInput = (0, _hooks.useInput)(policyIdDefaultValue, validatePolicyId);
  const onSubmit = async event => {
    event.preventDefault();
    if (!policyIdInput.validate() || !apiKeyNameInput.validate()) {
      return;
    }
    setIsLoading(true);
    try {
      var _res$data;
      const res = await (0, _hooks.sendCreateEnrollmentAPIKey)({
        name: apiKeyNameInput.value,
        policy_id: policyIdInput.value
      });
      if (res.error) {
        throw res.error;
      }
      policyIdInput.clear();
      apiKeyNameInput.clear();
      setIsLoading(false);
      if ((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.item) {
        onSuccess(res.data.item);
      }
    } catch (error) {
      setIsLoading(false);
      onError(error);
    }
  };
  return {
    isLoading,
    onSubmit,
    policyIdInput,
    apiKeyNameInput
  };
}
const NewEnrollmentTokenModal = ({
  onClose,
  agentPolicies = []
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const selectPolicyOptions = (0, _react.useMemo)(() => {
    return agentPolicies.filter(agentPolicy => !agentPolicy.is_managed).map(agentPolicy => ({
      value: agentPolicy.id,
      text: agentPolicy.name
    }));
  }, [agentPolicies]);
  const form = useCreateApiKeyForm(selectPolicyOptions.length > 0 ? selectPolicyOptions[0].value : undefined, key => {
    onClose(key);
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.newEnrollmentKey.keyCreatedToasts', {
      defaultMessage: 'Enrollment token created'
    }));
  }, error => {
    notifications.toasts.addError(error, {
      title: 'Error'
    });
  });
  const body = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: form.onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.nameLabel', {
      defaultMessage: 'Token name'
    }),
    helpText: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.helpText', {
      defaultMessage: 'Token id will be used when this is left empty.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "createEnrollmentTokenNameField",
    name: "name",
    autoComplete: "off",
    placeholder: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.placeholder', {
      defaultMessage: 'Enter a token name'
    })
  }, form.apiKeyNameInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.policyLabel', {
      defaultMessage: 'Policy'
    })
  }, form.policyIdInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    "data-test-subj": "createEnrollmentTokenSelectField",
    required: true
  }, form.policyIdInput.props, {
    options: selectPolicyOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  })))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    isLoading: form.isLoading,
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.modalTitle', {
      defaultMessage: 'Create enrollment token'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: () => onClose(),
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    onConfirm: form.onSubmit,
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.newEnrollmentKey.submitButton', {
      defaultMessage: 'Create enrollment token'
    }),
    confirmButtonDisabled: !form.policyIdInput.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, body);
};
exports.NewEnrollmentTokenModal = NewEnrollmentTokenModal;