"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _installation_message = require("../agent_enrollment_flyout/installation_message");
var _platform_selector = require("../platform_selector");
var _root_privileges_callout = require("./root_privileges_callout");
var _unprivileged_info = require("./unprivileged_info");
var _non_fips_integrations_callout = require("./non_fips_integrations_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/enrollment_instructions/install_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InstallSection = ({
  installCommand,
  isK8s,
  cloudSecurityIntegration,
  enrollToken,
  fleetServerHost,
  fullCopyButton = false,
  isManaged = true,
  onCopy,
  rootIntegrations,
  nonFipsIntegrations
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_installation_message.InstallationMessage, {
    isK8s: isK8s,
    isManaged: isManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_non_fips_integrations_callout.NonFipsIntegrationsCallout, {
    nonFipsIntegrations: nonFipsIntegrations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_root_privileges_callout.RootPrivilegesCallout, {
    rootIntegrations: rootIntegrations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_unprivileged_info.UnprivilegedInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_platform_selector.PlatformSelector, {
    fullCopyButton: fullCopyButton,
    onCopy: onCopy,
    installCommand: installCommand,
    hasK8sIntegration: isK8s === 'IS_KUBERNETES' || isK8s === 'IS_KUBERNETES_MULTIPAGE',
    cloudSecurityIntegration: cloudSecurityIntegration,
    hasK8sIntegrationMultiPage: isK8s === 'IS_KUBERNETES_MULTIPAGE',
    isManaged: isManaged,
    enrollToken: enrollToken,
    fleetServerHost: fleetServerHost,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
};
exports.InstallSection = InstallSection;