"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  AgentEnrollmentFlyout: true
};
exports.AgentEnrollmentFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _constants = require("../../constants");
var _ = require("..");
var _instructions = require("./instructions");
Object.keys(_instructions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _instructions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _instructions[key];
    }
  });
});
var _missing_fleet_server_host_callout = require("./missing_fleet_server_host_callout");
var _hooks2 = require("./hooks");
var _agent_policy_selection = require("./agent_policy_selection");
Object.keys(_agent_policy_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent_policy_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent_policy_selection[key];
    }
  });
});
var _agent_policy_select_create = require("./agent_policy_select_create");
Object.keys(_agent_policy_select_create).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent_policy_select_create[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent_policy_select_create[key];
    }
  });
});
var _steps = require("./steps");
Object.keys(_steps).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _steps[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _steps[key];
    }
  });
});
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentEnrollmentFlyout = ({
  onClose,
  agentPolicy,
  selectedAgentPolicies,
  defaultMode = 'managed',
  isIntegrationFlow,
  installedPackagePolicy
}) => {
  const authz = (0, _hooks.useAuthz)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id);
  const [isFleetServerPolicySelected, setIsFleetServerPolicySelected] = (0, _react.useState)(false);
  const [selectedApiKeyId, setSelectedAPIKeyId] = (0, _react.useState)();
  const [mode, setMode] = (0, _react.useState)(defaultMode);
  const [selectionType, setSelectionType] = (0, _react.useState)();
  const {
    agentPolicies: fetchedAgentPolicies,
    isLoadingInitialAgentPolicies,
    isLoadingAgentPolicies,
    refreshAgentPolicies
  } = (0, _hooks.useAgentEnrollmentFlyoutData)();

  // Have the option to pass agentPolicies from props, otherwise use the fetched ones
  const agentPolicies = selectedAgentPolicies ? selectedAgentPolicies : fetchedAgentPolicies;
  const {
    agentPolicyWithPackagePolicies
  } = (0, _hooks2.useAgentPolicyWithPackagePolicies)(selectedPolicyId);
  const {
    fleetServerHost,
    fleetProxy,
    downloadSource,
    isLoadingInitialRequest,
    downloadSourceProxy
  } = (0, _hooks.useFleetServerHostsForPolicy)(agentPolicyWithPackagePolicies);
  const selectedPolicy = agentPolicyWithPackagePolicies ? agentPolicyWithPackagePolicies : undefined;
  const hasNoFleetServerHost = fleetStatus.isReady && !fleetServerHost;
  (0, _react.useEffect)(() => {
    if (selectedPolicy) {
      if (selectedPolicy.package_policies.some(packagePolicy => {
        var _packagePolicy$packag;
        return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
      })) {
        setIsFleetServerPolicySelected(true);
      } else {
        setIsFleetServerPolicySelected(false);
      }
    }
  }, [selectedPolicy, isFleetServerPolicySelected]);
  const {
    isK8s
  } = (0, _hooks2.useIsK8sPolicy)(selectedPolicy !== null && selectedPolicy !== void 0 ? selectedPolicy : undefined);
  const {
    cloudSecurityIntegration
  } = (0, _hooks2.useCloudSecurityIntegration)(selectedPolicy !== null && selectedPolicy !== void 0 ? selectedPolicy : undefined);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "agentEnrollmentFlyout",
    onClose: onClose,
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.flyoutFleetServerTitle",
    defaultMessage: "Add Fleet Server",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.flyoutTitle",
    defaultMessage: "Add agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.instructionstFleetServer",
    defaultMessage: "A Fleet Server is required before you can enroll agents with Fleet. Follow the instructions below to set up a Fleet Server. For more information, see the {userGuideLink}",
    values: {
      userGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        external: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollment.setupGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.agentDescription",
    defaultMessage: "Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })), selectionType === 'tabs' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "managedTab",
    isSelected: mode === 'managed',
    onClick: () => setMode('managed'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.enrollFleetTabLabel",
    defaultMessage: "Enroll in Fleet",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "standaloneTab",
    isSelected: mode === 'standalone',
    onClick: () => setMode('standalone')
    // Standalone need read access to agent policies and cannot be used for Fleet Server policies
    ,
    disabled: !authz.fleet.readAgentPolicies || isFleetServerPolicySelected,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.enrollStandaloneTabLabel",
    defaultMessage: "Run standalone",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  })))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: hasNoFleetServerHost && !isLoadingInitialRequest && mode === 'managed' ? /*#__PURE__*/_react.default.createElement(_missing_fleet_server_host_callout.MissingFleetServerHostCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, isLoadingInitialAgentPolicies || isLoadingAgentPolicies ? /*#__PURE__*/_react.default.createElement(_.Loading, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_instructions.Instructions, {
    fleetServerHost: fleetServerHost,
    fleetProxy: fleetProxy,
    downloadSource: downloadSource,
    downloadSourceProxy: downloadSourceProxy,
    setSelectedPolicyId: setSelectedPolicyId,
    agentPolicy: agentPolicy,
    selectedPolicy: selectedPolicy,
    agentPolicies: agentPolicies,
    isFleetServerPolicySelected: isFleetServerPolicySelected,
    isK8s: isK8s,
    cloudSecurityIntegration: cloudSecurityIntegration,
    refreshAgentPolicies: refreshAgentPolicies,
    isLoadingAgentPolicies: isLoadingAgentPolicies,
    mode: mode,
    setMode: setMode,
    selectionType: selectionType,
    setSelectionType: setSelectionType,
    isIntegrationFlow: isIntegrationFlow,
    selectedApiKeyId: selectedApiKeyId,
    setSelectedAPIKeyId: setSelectedAPIKeyId,
    onClickViewAgents: onClose,
    installedPackagePolicy: installedPackagePolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.closeFlyoutButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }))))));
};
exports.AgentEnrollmentFlyout = AgentEnrollmentFlyout;