"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorIconPanel = ErrorIconPanel;
exports.IconPanel = IconPanel;
exports.LoadingIconPanel = LoadingIconPanel;
exports.MiniIcon = MiniIcon;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _components = require("../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/components/icon_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Panel = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeXL};
  width: ${props => parseFloat(props.theme.eui.euiSize) * 6 + parseFloat(props.theme.eui.euiSizeXL) * 2}px;
  svg,
  img {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    width: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
  }
  .euiFlexItem {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    justify-content: center;
  }
`;
function IconPanel({
  packageName,
  integrationName,
  version,
  icons
}) {
  const iconType = (0, _hooks.usePackageIconType)({
    packageName,
    integrationName,
    version,
    icons
  });
  return /*#__PURE__*/_react.default.createElement(Panel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "original",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
}
function LoadingIconPanel() {
  return /*#__PURE__*/_react.default.createElement(Panel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}
function ErrorIconPanel() {
  return /*#__PURE__*/_react.default.createElement(Panel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "error",
    size: "original",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}
function MiniIcon({
  packageName,
  integrationName,
  version,
  icons
}) {
  const iconType = (0, _hooks.usePackageIconType)({
    packageName,
    integrationName,
    version,
    icons
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
}