"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCheckPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/health_check_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const POLLING_INTERVAL_S = 10; // 10 sec
const POLLING_INTERVAL_MS = POLLING_INTERVAL_S * 1000;
const HealthCheckPanel = () => {
  var _error$message;
  const [selectedFleetServerHost, setSelectedFleetServerHost] = (0, _react.useState)();
  const {
    data
  } = (0, _hooks.useGetFleetServerHosts)();
  const fleetServerHosts = (0, _react.useMemo)(() => {
    var _data$items;
    return (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  }, [data === null || data === void 0 ? void 0 : data.items]);
  (0, _react.useEffect)(() => {
    const defaultHost = fleetServerHosts.find(item => item.is_default === true);
    if (defaultHost) {
      setSelectedFleetServerHost(defaultHost);
    }
  }, [fleetServerHosts]);
  const id = (0, _react.useMemo)(() => (selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id) || '', [selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id]);
  const [healthData, setHealthData] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const {
    data: healthCheckResponse
  } = (0, _reactQuery.useQuery)(['fleetServerHealth', id], () => (0, _hooks.sendPostHealthCheck)({
    id
  }), {
    refetchInterval: POLLING_INTERVAL_MS,
    enabled: !!id
  });
  (0, _react.useEffect)(() => {
    setHealthData(healthCheckResponse === null || healthCheckResponse === void 0 ? void 0 : healthCheckResponse.data);
    if (healthCheckResponse !== null && healthCheckResponse !== void 0 && healthCheckResponse.error) {
      setError(healthCheckResponse.error);
    }
  }, [healthCheckResponse]);
  const fleetServerHostsOptions = (0, _react.useMemo)(() => [...fleetServerHosts.map(fleetServerHost => {
    return {
      inputDisplay: `${fleetServerHost.name} (${fleetServerHost.host_urls[0]})`,
      value: fleetServerHost.id
    };
  })], [fleetServerHosts]);
  const healthStatus = statusValue => {
    if (!statusValue) return null;
    let color;
    switch (statusValue) {
      case 'HEALTHY':
        color = 'success';
        break;
      case 'UNHEALTHY':
        color = 'warning';
        break;
      case 'OFFLINE':
        color = 'subdued';
        break;
      default:
        color = 'subdued';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 12
      }
    }, statusValue);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.description",
    defaultMessage: "Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",
    values: {
      interval: POLLING_INTERVAL_S
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 600px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "data-test-subj": "fleetDebug.fleetServerHostsSelect",
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.healthCheckPanel.fleetServerHostsSelectAriaLabel', {
      defaultMessage: 'Fleet Server hosts'
    }),
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",
      defaultMessage: "Fleet Server Hosts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 17
      }
    })),
    onChange: fleetServerHostId => {
      setHealthData(undefined);
      setSelectedFleetServerHost(fleetServerHosts.find(fleetServerHost => fleetServerHost.id === fleetServerHostId));
    },
    valueOfSelected: selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id,
    options: fleetServerHostsOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, healthData !== null && healthData !== void 0 && healthData.status && id === (healthData === null || healthData === void 0 ? void 0 : healthData.host_id) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.status",
    defaultMessage: "Status:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, healthStatus(healthData === null || healthData === void 0 ? void 0 : healthData.status))) : null)), error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.fetchError",
    defaultMessage: "Message: {errorMessage}",
    values: {
      errorMessage: error === null || error === void 0 ? void 0 : error.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }))));
};
exports.HealthCheckPanel = HealthCheckPanel;