"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../components");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _utils = require("../utils");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _export_csv = require("../hooks/export_csv");
var _agent_export_csv_modal = require("../../components/agent_export_csv_modal");
var _tags_add_remove = require("./tags_add_remove");
var _migrate_agent_flyout = require("./migrate_agent_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentBulkActions = ({
  nAgentsInTable,
  totalManagedAgentIds,
  selectionMode,
  currentQuery,
  selectedAgents,
  agentsOnCurrentPage,
  refreshAgents,
  allTags,
  agentPolicies,
  sortField,
  sortOrder,
  unsupportedMigrateAgents
}) => {
  const licenseService = (0, _hooks.useLicense)();
  const authz = (0, _hooks.useAuthz)();
  const isLicenceAllowingScheduleUpgrade = licenseService.hasAtLeast(_constants.LICENSE_FOR_SCHEDULE_UPGRADE);
  const doesLicenseAllowMigration = licenseService.hasAtLeast(_constants.LICENSE_FOR_AGENT_MIGRATION);
  // Bulk actions menu states
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const closeMenu = () => setIsMenuOpen(false);
  const onClickMenu = () => setIsMenuOpen(!isMenuOpen);

  // Actions states
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(false);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [upgradeModalState, setUpgradeModalState] = (0, _react.useState)({
    isOpen: false,
    isScheduled: false,
    isUpdating: false
  });
  const [isTagAddVisible, setIsTagAddVisible] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isExportCSVModalOpen, setIsExportCSVModalOpen] = (0, _react.useState)(false);
  const [isMigrateModalOpen, setIsMigrateModalOpen] = (0, _react.useState)(false);

  // update the query removing the "managed" agents in any state (unenrolled, offline, etc)
  const selectionQuery = (0, _react.useMemo)(() => {
    if (totalManagedAgentIds.length) {
      const excludedKuery = `${_constants.AGENTS_PREFIX}.agent.id : (${totalManagedAgentIds.map(id => `"${id}"`).join(' or ')})`;
      return `(${currentQuery}) AND NOT (${excludedKuery})`;
    } else {
      return currentQuery;
    }
  }, [currentQuery, totalManagedAgentIds]);
  const agents = selectionMode === 'manual' ? selectedAgents : selectionQuery;
  const agentCount = selectionMode === 'manual' ? selectedAgents.length : nAgentsInTable - (totalManagedAgentIds === null || totalManagedAgentIds === void 0 ? void 0 : totalManagedAgentIds.length);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const {
    generateReportingJobCSV
  } = (0, _export_csv.useExportCSV)();
  const menuItems = [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.addRemoveTags",
      "data-test-subj": "agentBulkActionsAddRemoveTags",
      defaultMessage: "Add / remove tags",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "tag",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents,
    onClick: event => {
      setTagsPopoverButton(event.target.closest('button'));
      setIsTagAddVisible(!isTagAddVisible);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.bulkMigrateAgents",
      "data-test-subj": "agentBulkActionsBulkMigrate",
      defaultMessage: "Migrate {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cluster",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents || !doesLicenseAllowMigration,
    onClick: event => {
      closeMenu();
      setIsMigrateModalOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.reassignPolicy",
      "data-test-subj": "agentBulkActionsReassign",
      defaultMessage: "Assign to new policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setIsReassignFlyoutOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.upgradeAgents",
      "data-test-subj": "agentBulkActionsUpgrade",
      defaultMessage: "Upgrade {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "refresh",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: false,
        isUpdating: false
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.scheduleUpgradeAgents",
      "data-test-subj": "agentBulkActionsScheduleUpgrade",
      defaultMessage: "Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "timeRefresh",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents || !isLicenceAllowingScheduleUpgrade,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: true,
        isUpdating: false
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.restartUpgradeAgents",
      "data-test-subj": "agentBulkActionsRestartUpgrade",
      defaultMessage: "Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 9
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "refresh",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: false,
        isUpdating: true
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.requestDiagnostics",
      "data-test-subj": "agentBulkActionsRequestDiagnostics",
      defaultMessage: "Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 9
      }
    }),
    disabled: !authz.fleet.readAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "download",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }),
    onClick: () => {
      closeMenu();
      setIsRequestDiagnosticsModalOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.unenrollAgents",
      "data-test-subj": "agentBulkActionsUnenroll",
      defaultMessage: "Unenroll {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 9
      }
    }),
    disabled: !authz.fleet.allAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }),
    onClick: () => {
      closeMenu();
      setIsUnenrollModalOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.exportAgents",
      "data-test-subj": "bulkAgentExportBtn",
      defaultMessage: "Export {agentCount, plural, one {# agent} other {# agents}} as CSV",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 9
      }
    }),
    disabled: !authz.fleet.readAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "exportAction",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 13
      }
    }),
    onClick: () => {
      closeMenu();
      setIsExportCSVModalOpen(true);
    }
  }];
  const panels = [{
    id: 0,
    items: menuItems
  }];
  const getSelectedTagsFromAgents = (0, _react.useMemo)(() => (0, _utils.getCommonTags)(agents, agentsOnCurrentPage !== null && agentsOnCurrentPage !== void 0 ? agentsOnCurrentPage : [], agentPolicies), [agents, agentsOnCurrentPage, agentPolicies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentReassignAgentPolicyModal, {
    agents: agents,
    onClose: () => {
      setIsReassignFlyoutOpen(false);
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 11
    }
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUnenrollAgentModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgents({
        refreshTags: true
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  })), isExportCSVModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_export_csv_modal.AgentExportCSVModal, {
    onSubmit: columns => {
      generateReportingJobCSV(agents, columns, {
        field: sortField,
        direction: sortOrder
      });
      setIsExportCSVModalOpen(false);
    },
    onClose: () => {
      setIsExportCSVModalOpen(false);
    },
    agentCount: agentCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 11
    }
  })), upgradeModalState.isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUpgradeAgentModal, {
    agents: agents,
    agentCount: agentCount,
    isScheduled: upgradeModalState.isScheduled,
    isUpdating: upgradeModalState.isUpdating,
    onClose: () => {
      setUpgradeModalState({
        isOpen: false,
        isScheduled: false,
        isUpdating: false
      });
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 11
    }
  })), isTagAddVisible && /*#__PURE__*/_react.default.createElement(_tags_add_remove.TagsAddRemove, {
    agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: getSelectedTagsFromAgents,
    button: tagsPopoverButton,
    onTagsUpdated: () => {
      refreshAgents({
        refreshTags: true
      });
    },
    onClosePopover: () => {
      setIsTagAddVisible(false);
      closeMenu();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 9
    }
  }), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  })), isMigrateModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_migrate_agent_flyout.AgentMigrateFlyout, {
    agents: agents,
    agentCount: agentCount,
    unsupportedMigrateAgents: unsupportedMigrateAgents,
    onClose: () => {
      setIsMigrateModalOpen(false);
    },
    onSave: () => {
      setIsMigrateModalOpen(false);
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "agentBulkActionsMenu",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onClickMenu,
      "data-test-subj": "agentBulkActionsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.actions",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 17
      }
    })),
    isOpen: isMenuOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 13
    }
  })))));
};
exports.AgentBulkActions = AgentBulkActions;