"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActivityFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../hooks");
var _hooks2 = require("../../../../../hooks");
var _constants = require("../../../../../constants");
var _get_kuery = require("../../utils/get_kuery");
var _agent_status = require("../../../services/agent_status");
var _flyout_body = require("./flyout_body");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_activity_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutFooterWPadding = (0, _styledComponents.default)(_eui.EuiFlyoutFooter)`
  padding: 16px 24px !important;
`;
const AgentActivityFlyout = ({
  onClose,
  onAbortSuccess,
  refreshAgentActivity,
  setSearch,
  setSelectedStatus,
  openManageAutoUpgradeModal
}) => {
  const {
    notifications
  } = (0, _hooks2.useStartServices)();
  const {
    data: agentPoliciesData
  } = (0, _hooks2.useGetAgentPolicies)({
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const defaultNActions = 20;
  const [nActions, setNActions] = (0, _react.useState)(defaultNActions);
  const [dateFilter, setDateFilter] = (0, _react.useState)(null);
  const {
    currentActions,
    abortUpgrade,
    isFirstLoading,
    areActionsFullyLoaded
  } = (0, _hooks.useActionStatus)(onAbortSuccess, refreshAgentActivity, nActions, dateFilter);
  const getAgentPolicyName = (0, _react.useCallback)(policyId => {
    var _policy$name;
    const policy = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items.find(item => item.id === policyId);
    return (_policy$name = policy === null || policy === void 0 ? void 0 : policy.name) !== null && _policy$name !== void 0 ? _policy$name : policyId;
  }, [agentPoliciesData]);
  const currentActionsEnriched = (0, _react.useMemo)(() => currentActions.map(a => {
    var _a$newPolicyId, _a$newPolicyId2;
    return {
      ...a,
      newPolicyId: getAgentPolicyName((_a$newPolicyId = a.newPolicyId) !== null && _a$newPolicyId !== void 0 ? _a$newPolicyId : ''),
      policyId: a.policyId ? a.policyId : getAgentPolicyName((_a$newPolicyId2 = a.newPolicyId) !== null && _a$newPolicyId2 !== void 0 ? _a$newPolicyId2 : '')
    };
  }), [currentActions, getAgentPolicyName]);
  const onClickViewAgents = async action => {
    try {
      var _data$items;
      const {
        data
      } = await (0, _hooks2.sendPostRetrieveAgentsByActions)({
        actionIds: [action.actionId]
      });
      if (data !== null && data !== void 0 && (_data$items = data.items) !== null && _data$items !== void 0 && _data$items.length) {
        const kuery = (0, _get_kuery.getKuery)({
          selectedAgentIds: data.items
        });
        setSearch(kuery);
      }
      setSelectedStatus(_agent_status.AGENT_STATUSES);
      onClose();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.agentActivityFlyout.error', {
          defaultMessage: 'Error viewing selected agents'
        })
      });
    }
  };
  const onClickManageAutoUpgradeAgents = async action => {
    //  use the policy id from the action to manage
    onClose();
    openManageAutoUpgradeModal(action.policyId);
  };
  const onClickShowMore = () => {
    setNActions(nActions + 10);
  };
  const onChangeDateFilter = date => {
    var _date$startOf;
    setDateFilter((_date$startOf = date === null || date === void 0 ? void 0 : date.startOf('day')) !== null && _date$startOf !== void 0 ? _date$startOf : null);
    setNActions(defaultNActions);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "agentActivityFlyout",
    onClose: () => {
      // stop polling action status API
      refreshAgentActivity = false;
      onClose();
    },
    paddingSize: "none",
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    "aria-labelledby": "FleetAgentActivityFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.title",
    defaultMessage: "Agent activity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.activityLogText",
    defaultMessage: "Activity log of Elastic Agent operations will appear here.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 21
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    isFirstLoading: isFirstLoading,
    currentActions: currentActionsEnriched,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents,
    areActionsFullyLoaded: areActionsFullyLoaded,
    onClickShowMore: onClickShowMore,
    dateFilter: dateFilter,
    onChangeDateFilter: onChangeDateFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutFooterWPadding, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.closeBtn",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }))))))));
};
exports.AgentActivityFlyout = AgentActivityFlyout;