"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackagePolicySteps = usePackagePolicySteps;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _use_space_settings_context = require("../../../../../../hooks/use_space_settings_context");
var _services = require("../../../../../../../common/services");
var _components = require("../../create_package_policy_page/components");
var _types = require("../../../../types");
var _hooks = require("../../create_package_policy_page/single_page_layout/hooks");
var _components2 = require("../../components");
var _form = require("../../create_package_policy_page/single_page_layout/hooks/form");
var _step_edit_hosts = require("../components/step_edit_hosts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/edit_package_policy_page/hooks/use_package_policy_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function usePackagePolicySteps({
  configureStep,
  packageInfo,
  existingAgentPolicies,
  setHasAgentPolicyError,
  updatePackagePolicy,
  agentPolicies,
  setAgentPolicies,
  isLoadingData,
  packagePolicy,
  packagePolicyId,
  setNewAgentPolicyName
}) {
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)((0, _services.generateNewAgentPolicyWithDefaults)({
    name: 'Agent policy 1',
    namespace: spaceSettings.defaultNamespace
  }));
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const [selectedPolicyTab, setSelectedPolicyTab] = (0, _react.useState)(_components.SelectedPolicyTab.EXISTING);
  const validation = (0, _components2.agentPolicyFormValidation)(newAgentPolicy);
  const setPolicyValidation = (0, _react.useCallback)((currentTab, updatedAgentPolicy) => {
    if (currentTab === _components.SelectedPolicyTab.NEW) {
      if (!updatedAgentPolicy.name || updatedAgentPolicy.name.trim() === '' || !updatedAgentPolicy.namespace || updatedAgentPolicy.namespace.trim() === '') {
        setHasAgentPolicyError(true);
      } else {
        setHasAgentPolicyError(false);
      }
    }
  }, [setHasAgentPolicyError]);
  const updateSelectedPolicyTab = (0, _react.useCallback)(currentTab => {
    setSelectedPolicyTab(currentTab);
    setPolicyValidation(currentTab, newAgentPolicy);
  }, [setSelectedPolicyTab, setPolicyValidation, newAgentPolicy]);

  // Update agent policy method
  const updateAgentPolicies = (0, _react.useCallback)(updatedAgentPolicies => {
    if (!isLoadingData && (0, _lodash.isEqual)(updatedAgentPolicies, agentPolicies)) {
      return;
    }
    setAgentPolicies(updatedAgentPolicies);
    updatePackagePolicy({
      policy_ids: updatedAgentPolicies.map(policy => policy.id)
    });
    if (packageInfo) {
      setHasAgentPolicyError(false);
    }

    // eslint-disable-next-line no-console
    console.debug('Agent policy updated', updatedAgentPolicies);
  }, [packageInfo, agentPolicies, isLoadingData, updatePackagePolicy, setHasAgentPolicyError, setAgentPolicies]);
  const updateNewAgentPolicy = (0, _react.useCallback)(updatedFields => {
    const updatedAgentPolicy = {
      ...newAgentPolicy,
      ...updatedFields
    };
    setNewAgentPolicy(updatedAgentPolicy);
    setPolicyValidation(selectedPolicyTab, updatedAgentPolicy);
  }, [setNewAgentPolicy, setPolicyValidation, newAgentPolicy, selectedPolicyTab]);
  const {
    selectedSetupTechnology
  } = (0, _hooks.useSetupTechnology)({
    newAgentPolicy,
    setNewAgentPolicy,
    updatePackagePolicy,
    setSelectedPolicyTab,
    packagePolicy,
    isEditPage: true,
    agentPolicies
  });
  const stepSelectAgentPolicy = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_step_edit_hosts.StepEditHosts, {
    agentPolicies: agentPolicies,
    updateAgentPolicies: updateAgentPolicies,
    newAgentPolicy: newAgentPolicy,
    updateNewAgentPolicy: updateNewAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: newValue => setWithSysMonitoring(newValue),
    validation: validation,
    packageInfo: packageInfo,
    setHasAgentPolicyError: setHasAgentPolicyError,
    updateSelectedTab: updateSelectedPolicyTab,
    selectedAgentPolicyIds: existingAgentPolicies.map(policy => policy.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), [packageInfo, agentPolicies, updateAgentPolicies, newAgentPolicy, updateNewAgentPolicy, validation, withSysMonitoring, updateSelectedPolicyTab, setHasAgentPolicyError, existingAgentPolicies, setWithSysMonitoring]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigurePackagePolicyTitle', {
      defaultMessage: 'Configure integration'
    }),
    'data-test-subj': 'dataCollectionSetupStep',
    children: configureStep,
    headingElement: 'h2'
  }];
  if (selectedSetupTechnology !== _types.SetupTechnology.AGENTLESS) {
    steps.push({
      title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepSelectAgentPolicyTitle', {
        defaultMessage: 'Where to add this integration?'
      }),
      children: stepSelectAgentPolicy,
      headingElement: 'h2'
    });
  }
  const devToolsProps = (0, _hooks.useDevToolsRequest)({
    newAgentPolicy,
    packagePolicy,
    selectedPolicyTab,
    withSysMonitoring,
    packageInfo,
    packagePolicyId
  });
  (0, _react.useEffect)(() => {
    setNewAgentPolicyName(selectedPolicyTab === _components.SelectedPolicyTab.NEW ? newAgentPolicy.name : undefined);
  }, [newAgentPolicy, selectedPolicyTab, setNewAgentPolicyName]);
  return {
    steps,
    devToolsProps,
    createAgentPolicyIfNeeded: async () => {
      const createdAgentPolicy = await (0, _form.createAgentPolicyIfNeeded)({
        newAgentPolicy,
        packagePolicy,
        withSysMonitoring,
        packageInfo,
        selectedPolicyTab
      });
      return createdAgentPolicy === null || createdAgentPolicy === void 0 ? void 0 : createdAgentPolicy.id;
    }
  };
}