"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicyPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../../../hooks");
var _services = require("../../../../../../common/services");
var _single_page_layout = require("./single_page_layout");
var _multi_page_layout = require("./multi_page_layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreatePackagePolicyPage = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    params
  } = (0, _reactRouterDom.useRouteMatch)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const useMultiPageLayout = (0, _react.useMemo)(() => queryParams.has('useMultiPageLayout'), [queryParams]);
  const queryParamsPolicyId = (0, _react.useMemo)(() => {
    var _queryParams$get;
    return (_queryParams$get = queryParams.get('policyId')) !== null && _queryParams$get !== void 0 ? _queryParams$get : undefined;
  }, [queryParams]);
  const [prerelease, setPrerelease] = _react.default.useState(false);
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(params.pkgkey);
  const {
    data: settings
  } = (0, _hooks.useGetSettings)();
  const queryParamPrerelease = (0, _react.useMemo)(() => Boolean(queryParams.get('prerelease')), [queryParams]);
  (0, _react.useEffect)(() => {
    const isEnabled = Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled) || queryParamPrerelease;
    if (settings !== null && settings !== void 0 && settings.item) {
      setPrerelease(isEnabled);
    }
  }, [queryParamPrerelease, settings === null || settings === void 0 ? void 0 : settings.item]);

  /**
   * Please note: policyId can come from one of two sources. The URL param (in the URL path) or
   * in the query params (?policyId=foo).
   *
   * Either way, we take this as an indication that a user is "coming from" the fleet policy UI
   * since we link them out to packages (a.k.a. integrations) UI when choosing a new package. It is
   * no longer possible to choose a package directly in the create package form.
   *
   * We may want to deprecate the ability to pass in policyId from URL params since there is no package
   * creation possible if a user has not chosen one from the packages UI.
   */
  const from = 'policyId' in params || queryParamsPolicyId ? 'policy' : 'package';
  const pageParams = {
    from,
    queryParamsPolicyId,
    prerelease,
    pkgName,
    pkgVersion,
    integration: params.integration
  };
  if (useMultiPageLayout) {
    return /*#__PURE__*/_react.default.createElement(_multi_page_layout.CreatePackagePolicyMultiPage, (0, _extends2.default)({}, pageParams, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_single_page_layout.CreatePackagePolicySinglePage, (0, _extends2.default)({}, pageParams, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 10
    }
  }));
};
exports.CreatePackagePolicyPage = CreatePackagePolicyPage;