"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepConfigurePackagePolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../../common/services");
var _agentless_policy_helper = require("../../../../../../../../common/services/agentless_policy_helper");
var _components = require("../../../../../components");
var _services2 = require("../../../../../services");
var _components2 = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/step_configure_package.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepConfigurePackagePolicy = ({
  packageInfo,
  showOnlyIntegration,
  packagePolicy,
  updatePackagePolicy,
  validationResults,
  submitAttempted,
  noTopRule = false,
  isEditPage = false,
  isAgentlessSelected = false
}) => {
  const hasIntegrations = (0, _react.useMemo)(() => (0, _services2.doesPackageHaveIntegrations)(packageInfo), [packageInfo]);
  const deploymentMode = (isEditPage || isAgentlessSelected) && packagePolicy.supports_agentless ? 'agentless' : 'default';
  const packagePolicyTemplates = (0, _react.useMemo)(() => showOnlyIntegration ? (packageInfo.policy_templates || []).filter(policyTemplate => policyTemplate.name === showOnlyIntegration) : packageInfo.policy_templates || [], [packageInfo.policy_templates, showOnlyIntegration]);
  // Configure inputs (and their streams)
  const renderConfigureInputs = () => packagePolicyTemplates.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !noTopRule && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 24
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, packagePolicyTemplates.map(policyTemplate => {
    const inputs = (0, _services.getNormalizedInputs)(policyTemplate);
    const packagePolicyInputs = packagePolicy.inputs;
    return inputs.map(packageInput => {
      var _validationResults$in, _validationResults$in2;
      const packagePolicyInput = packagePolicyInputs.find(input => input.type === packageInput.type && (hasIntegrations ? input.policy_template === policyTemplate.name : true));
      const packageInputStreams = (0, _services.getRegistryStreamWithDataStreamForInputType)(packageInput.type, packageInfo, hasIntegrations && (0, _services.isIntegrationPolicyTemplate)(policyTemplate) ? policyTemplate.data_streams : []);
      const updatePackagePolicyInput = updatedInput => {
        const indexOfUpdatedInput = packagePolicyInputs.findIndex(input => input.type === packageInput.type && (hasIntegrations ? input.policy_template === policyTemplate.name : true));
        const newInputs = [...packagePolicyInputs];
        newInputs[indexOfUpdatedInput] = {
          ...newInputs[indexOfUpdatedInput],
          ...updatedInput
        };
        updatePackagePolicy({
          inputs: newInputs
        });
      };
      const isInputAvailable = packagePolicyInput && (0, _agentless_policy_helper.isInputAllowedForDeploymentMode)(packagePolicyInput, deploymentMode, packageInfo);
      return isInputAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: packageInput.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputPanel, {
        packageInput: packageInput,
        packageInfo: packageInfo,
        packageInputStreams: packageInputStreams,
        packagePolicyInput: packagePolicyInput,
        updatePackagePolicyInput: updatePackagePolicyInput,
        inputValidationResults: (_validationResults$in = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$in2 = validationResults.inputs) === null || _validationResults$in2 === void 0 ? void 0 : _validationResults$in2[hasIntegrations ? `${policyTemplate.name}-${packagePolicyInput.type}` : packagePolicyInput.type]) !== null && _validationResults$in !== void 0 ? _validationResults$in : {},
        forceShowErrors: submitAttempted,
        isEditPage: isEditPage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 19
        }
      })) : null;
    });
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "checkInCircleFilled",
    iconColor: "success",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.noPolicyOptionsMessage",
      defaultMessage: "Nothing to configure",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  });
  return validationResults ? renderConfigureInputs() : /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 56
    }
  });
};
exports.StepConfigurePackagePolicy = StepConfigurePackagePolicy;