"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionMetricPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
var _services = require("./services");
var _expression_renderers = require("./expression_renderers");
var _theme_service = require("./services/theme_service");
var _ui_settings = require("./services/ui_settings");
var _metric_trendline_function = require("../common/expression_functions/metric_trendline_function");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */
class ExpressionMetricPlugin {
  setup(core, {
    expressions,
    charts
  }) {
    const getStartDeps = (0, _public.createStartServicesGetter)(core.getStartServices);
    charts.palettes.getPalettes().then(palettes => {
      (0, _services.setPaletteService)(palettes);
    });
    expressions.registerFunction(_common.metricVisFunction);
    expressions.registerFunction(_metric_trendline_function.metricTrendlineFunction);
    expressions.registerRenderer((0, _expression_renderers.getMetricVisRenderer)({
      getStartDeps
    }));
    (0, _ui_settings.setUiSettingsService)(core.uiSettings);
    (0, _theme_service.setThemeService)(charts.theme);
  }
  start(core, {
    fieldFormats
  }) {
    (0, _services.setFormatService)(fieldFormats);
  }
}
exports.ExpressionMetricPlugin = ExpressionMetricPlugin;