"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterValuesList = FilterValuesList;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _polished = require("polished");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _filter_value_btn = require("../columns/filter_value_btn");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/components/filter_values_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FilterValuesList({
  field,
  values,
  query,
  setQuery,
  label,
  loading,
  isNegated,
  nestedField,
  series,
  seriesId
}) {
  var _series$filters;
  const [isNestedOpen, setIsNestedOpen] = (0, _react.useState)({
    value: '',
    negate: false
  });
  const displayValues = (0, _lodash.map)(values, 'label').filter(opt => opt.toLowerCase().includes(query.toLowerCase()));
  const filters = (_series$filters = series === null || series === void 0 ? void 0 : series.filters) !== null && _series$filters !== void 0 ? _series$filters : [];
  const currFilter = filters.find(({
    field: fd
  }) => field === fd);
  const btnProps = {
    field,
    nestedField,
    seriesId,
    series,
    isNestedOpen,
    setIsNestedOpen
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "o11yFilterValuesListFieldSearch",
    fullWidth: true,
    isLoading: loading,
    value: query,
    onChange: evt => {
      setQuery(evt.target.value);
    },
    placeholder: getSearchLabel(label),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ListWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, loading && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textCenter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    style: {
      top: 'initial'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  })), displayValues.length === 0 && !loading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textCenter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, NO_RESULT_FOUND), displayValues.map(opt => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: opt,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true,
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, isNegated !== false && /*#__PURE__*/_react.default.createElement(_filter_value_btn.FilterValueButton, (0, _extends2.default)({}, btnProps, {
    value: opt,
    negate: true,
    allSelectedValues: currFilter === null || currFilter === void 0 ? void 0 : currFilter.notValues,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_filter_value_btn.FilterValueButton, (0, _extends2.default)({}, btnProps, {
    value: opt,
    negate: false,
    allSelectedValues: currFilter === null || currFilter === void 0 ? void 0 : currFilter.values,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  })))));
}
const NO_RESULT_FOUND = _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.noFilter', {
  defaultMessage: 'No filters found.'
});
const getSearchLabel = label => _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.search', {
  defaultMessage: 'Search for {label}',
  values: {
    label
  }
});
const ListWrapper = _styled.default.div`
  height: 370px;
  overflow-y: auto;
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.euiTheme.size.base};
    width: ${({
  theme
}) => theme.euiTheme.size.base};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.euiTheme.colors.darkShade, 0.5)};
    border: ${({
  theme
}) => theme.euiTheme.border.radius.small} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const Wrapper = _styled.default.div`
  width: 400px;
`;