"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIME_SPAN_UNITS = exports.TIME_DURATION_UNITS = exports.SOURCE_COMMANDS = exports.HIDDEN_CHANNEL = exports.DEFAULT_CHANNEL = exports.DATE_PERIOD_UNITS = void 0;
var _antlr = require("antlr4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_CHANNEL = exports.DEFAULT_CHANNEL = +_antlr.Token.DEFAULT_CHANNEL;
const HIDDEN_CHANNEL = exports.HIDDEN_CHANNEL = +_antlr.Token.HIDDEN_CHANNEL;
const SOURCE_COMMANDS = exports.SOURCE_COMMANDS = new Set(['FROM', 'ROW', 'SHOW', 'TS', 'EXPLAIN']);

// FROM https://github.com/elastic/elasticsearch/blob/a2dbb7b9174b109d89fa2da87645ecd4d4e8de14/x-pack/plugin/esql/src/main/java/org/elasticsearch/xpack/esql/type/EsqlDataTypeConverter.java#L174
const TIME_DURATION_UNITS = exports.TIME_DURATION_UNITS = new Set(['millisecond', 'milliseconds', 'ms', 'second', 'seconds', 'sec', 's', 'minute', 'minutes', 'min', 'm', 'hour', 'hours', 'h']);

// FROM https://github.com/elastic/elasticsearch/blob/a2dbb7b9174b109d89fa2da87645ecd4d4e8de14/x-pack/plugin/esql/src/main/java/org/elasticsearch/xpack/esql/type/EsqlDataTypeConverter.java#L174
const DATE_PERIOD_UNITS = exports.DATE_PERIOD_UNITS = new Set(['year', 'years', 'yr', 'y', 'quarter', 'quarters', 'q', 'month', 'months', 'mo', 'week', 'weeks', 'w', 'day', 'days', 'd']);
const TIME_SPAN_UNITS = exports.TIME_SPAN_UNITS = [...DATE_PERIOD_UNITS, ...TIME_DURATION_UNITS];