"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainApp = DiscoverMainApp;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _redux = require("../../state_management/redux");
var _layout = require("../layout");
var _help_menu_util = require("../../../../components/help_menu/help_menu_util");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _saved_search_alias_match_redirect = require("../../../../hooks/saved_search_alias_match_redirect");
var _use_adhoc_data_views = require("../../hooks/use_adhoc_data_views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/single_tab_view/main_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverLayoutMemoized = /*#__PURE__*/_react.default.memo(_layout.DiscoverLayout);
function DiscoverMainApp({
  stateContainer
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const discoverSession = (0, _redux.useInternalStateSelector)(state => state.persistedDiscoverSession);
  const {
    chrome,
    docLinks,
    spaces,
    history
  } = services;

  /**
   * Adhoc data views functionality
   */
  (0, _use_adhoc_data_views.useAdHocDataViews)();

  // TODO: Move this higher up in the component tree
  (0, _react.useEffect)(() => {
    (0, _help_menu_util.addHelpMenuToAppChrome)(chrome, docLinks);
  }, [chrome, docLinks]);

  // TODO: Move this higher up in the component tree
  (0, _saved_search_alias_match_redirect.useSavedSearchAliasMatchRedirect)({
    discoverSession,
    spaces,
    history
  });
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DiscoverLayoutMemoized, {
    stateContainer: stateContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}