"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSidebarResponsive = DiscoverSidebarResponsive;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _public = require("@kbn/unified-search-plugin/public");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _calc_field_counts = require("@kbn/discover-utils/src/utils/calc_field_counts");
var _context_awareness = require("../../../../context_awareness");
var _common = require("../../../../../common");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _sidebar_reducer = require("./lib/sidebar_reducer");
var _customizations = require("../../../../customizations");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _redux = require("../../state_management/redux");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/sidebar/discover_sidebar_responsive.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_FIELD_COUNTS = {};
const getCreationOptions = () => {
  return {
    originatingApp: _common.PLUGIN_ID,
    localStorageKeyPrefix: 'discover',
    compressed: true,
    showSidebarToggleButton: true,
    disableFieldsExistenceAutoFetching: true,
    shouldKeepAdHocDataViewImmutable: true,
    buttonAddFieldVariant: 'toolbar',
    buttonAddFieldToWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('discover.fieldChooser.discoverField.addFieldTooltip', {
        defaultMessage: 'Add field as column'
      })
    },
    buttonRemoveFieldFromWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('discover.fieldChooser.discoverField.removeFieldTooltip', {
        defaultMessage: 'Remove field from table'
      })
    },
    onOverrideFieldGroupDetails: groupName => {
      if (groupName === _unifiedFieldList.FieldsGroupNames.AvailableFields) {
        return {
          helpText: _i18n.i18n.translate('discover.fieldChooser.availableFieldsTooltip', {
            defaultMessage: 'Fields available for display in the table.'
          })
        };
      }
    },
    dataTestSubj: {
      fieldListAddFieldButtonTestSubj: 'dataView-add-field_btn',
      fieldListSidebarDataTestSubj: 'discover-sidebar',
      fieldListItemStatsDataTestSubj: 'dscFieldStats',
      fieldListItemDndDataTestSubjPrefix: 'dscFieldListPanelField',
      fieldListItemPopoverDataTestSubj: 'discoverFieldListPanelPopover',
      fieldListItemPopoverHeaderDataTestSubjPrefix: 'discoverFieldListPanel'
    }
  };
};
/**
 * Component providing 2 different renderings for the sidebar depending on available screen space
 * Desktop: Sidebar view, all elements are visible
 * Mobile: Data view selector is visible and a button to trigger a flyout with all elements
 */

function DiscoverSidebarResponsive(props) {
  var _unifiedFieldListSide;
  const [unifiedFieldListSidebarContainerApi, setUnifiedFieldListSidebarContainerApi] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const {
    fieldListVariant,
    selectedDataView,
    columns,
    trackUiMetric,
    onAddBreakdownField,
    onAddFilter,
    onFieldEdited,
    onDataViewCreated,
    onChangeDataView,
    onAddField,
    onRemoveField,
    sidebarToggleState$,
    additionalFilters
  } = props;
  const [sidebarState, dispatchSidebarStateAction] = (0, _react.useReducer)(_sidebar_reducer.discoverSidebarReducer, selectedDataView, _sidebar_reducer.getInitialState);
  const selectedDataViewRef = (0, _react.useRef)(selectedDataView);
  const showFieldList = sidebarState.status !== _sidebar_reducer.DiscoverSidebarReducerStatus.INITIAL;
  const {
    savedDataViews,
    adHocDataViews
  } = (0, _redux.useDataViewsForPicker)();
  (0, _react.useEffect)(() => {
    const subscription = props.documents$.subscribe(documentState => {
      switch (documentState === null || documentState === void 0 ? void 0 : documentState.fetchStatus) {
        case _types.FetchStatus.UNINITIALIZED:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.RESET,
            payload: {
              dataView: selectedDataViewRef.current
            }
          });
          break;
        case _types.FetchStatus.LOADING:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADING,
            payload: {
              isEsqlMode
            }
          });
          break;
        case _types.FetchStatus.COMPLETE:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADED,
            payload: {
              dataView: selectedDataViewRef.current,
              fieldCounts: isEsqlMode ? EMPTY_FIELD_COUNTS : (0, _calc_field_counts.calcFieldCounts)(documentState.result),
              esqlQueryColumns: documentState.esqlQueryColumns,
              isEsqlMode
            }
          });
          break;
        case _types.FetchStatus.ERROR:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADED,
            payload: {
              dataView: selectedDataViewRef.current,
              fieldCounts: EMPTY_FIELD_COUNTS,
              isEsqlMode
            }
          });
          break;
        default:
          break;
      }
    });
    return () => subscription.unsubscribe();
  }, [props.documents$, dispatchSidebarStateAction, selectedDataViewRef, isEsqlMode]);
  (0, _react.useEffect)(() => {
    if (selectedDataView !== selectedDataViewRef.current) {
      dispatchSidebarStateAction({
        type: _sidebar_reducer.DiscoverSidebarReducerActionType.DATA_VIEW_SWITCHED,
        payload: {
          dataView: selectedDataView
        }
      });
      selectedDataViewRef.current = selectedDataView;
    }
  }, [selectedDataView, dispatchSidebarStateAction, selectedDataViewRef]);
  const refetchFieldsExistenceInfo = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.refetchFieldsExistenceInfo;
  const scheduleFieldsExistenceInfoFetchRef = (0, _react.useRef)(false);

  // Refetch fields existence info only after the fetch completes
  (0, _react.useEffect)(() => {
    scheduleFieldsExistenceInfoFetchRef.current = false;
    if (sidebarState.status !== _sidebar_reducer.DiscoverSidebarReducerStatus.COMPLETED) {
      return;
    }

    // refetching info only if status changed to completed

    if (refetchFieldsExistenceInfo) {
      refetchFieldsExistenceInfo();
    } else {
      scheduleFieldsExistenceInfoFetchRef.current = true;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sidebarState.status, scheduleFieldsExistenceInfoFetchRef]);

  // As unifiedFieldListSidebarContainerRef ref can be empty in the beginning,
  // we need to fetch the data once API becomes available and after documents are fetched
  const initializeUnifiedFieldListSidebarContainerApi = (0, _react.useCallback)(api => {
    if (!api) {
      return;
    }
    if (scheduleFieldsExistenceInfoFetchRef.current) {
      scheduleFieldsExistenceInfoFetchRef.current = false;
      api.refetchFieldsExistenceInfo();
    }
    setUnifiedFieldListSidebarContainerApi(api);
  }, [setUnifiedFieldListSidebarContainerApi, scheduleFieldsExistenceInfoFetchRef]);
  const {
    dataViewEditor
  } = services;
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || Boolean(selectedDataView && !selectedDataView.isPersisted());
  const closeFieldListFlyout = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.closeFieldListFlyout;
  const createNewDataView = (0, _react.useMemo)(() => canEditDataView ? dataView => {
    onDataViewCreated(dataView);
    closeFieldListFlyout === null || closeFieldListFlyout === void 0 ? void 0 : closeFieldListFlyout();
  } : undefined, [canEditDataView, onDataViewCreated, closeFieldListFlyout]);
  const searchBarCustomization = (0, _customizations.useDiscoverCustomization)('search_bar');
  const getRecommendedFieldsAccessor = (0, _context_awareness.useProfileAccessor)('getRecommendedFields');
  const additionalFieldGroups = (0, _react.useMemo)(() => {
    return getRecommendedFieldsAccessor(() => ({
      recommendedFields: []
    }))();
  }, [getRecommendedFieldsAccessor]);
  const CustomDataViewPicker = searchBarCustomization === null || searchBarCustomization === void 0 ? void 0 : searchBarCustomization.CustomDataViewPicker;
  const createField = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.createField;
  const prependDataViewPickerForMobile = (0, _react.useCallback)(() => {
    return selectedDataView ? CustomDataViewPicker ? /*#__PURE__*/_react.default.createElement(CustomDataViewPicker, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
      currentDataViewId: selectedDataView.id,
      adHocDataViews: adHocDataViews,
      savedDataViews: savedDataViews,
      onChangeDataView: onChangeDataView,
      onAddField: createField,
      onDataViewCreated: createNewDataView,
      trigger: {
        label: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) || '',
        'data-test-subj': 'dataView-switch-link',
        title: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getIndexPattern()) || '',
        fullWidth: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 9
      }
    }) : null;
  }, [selectedDataView, CustomDataViewPicker, adHocDataViews, savedDataViews, onChangeDataView, createField, createNewDataView]);
  const onAddFieldToWorkspace = (0, _react.useCallback)(field => {
    onAddField(field.name);
  }, [onAddField]);
  const onRemoveFieldFromWorkspace = (0, _react.useCallback)(field => {
    onRemoveField(field.name);
  }, [onRemoveField]);
  const isSidebarCollapsed = (0, _useObservable.default)((_unifiedFieldListSide = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.sidebarVisibility.isCollapsed$) !== null && _unifiedFieldListSide !== void 0 ? _unifiedFieldListSide : (0, _rxjs.of)(false), false);
  (0, _react.useEffect)(() => {
    sidebarToggleState$.next({
      isCollapsed: isSidebarCollapsed,
      toggle: unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.sidebarVisibility.toggle
    });
  }, [isSidebarCollapsed, unifiedFieldListSidebarContainerApi, sidebarToggleState$]);
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const fieldListUiState = (0, _redux.useCurrentTabSelector)(state => state.uiState.fieldList);
  const setFieldListUiState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setFieldListUiState);
  const onInitialStateChange = (0, _react.useCallback)(newFieldListUiState => {
    dispatch(setFieldListUiState({
      fieldListUiState: newFieldListUiState
    }));
  }, [dispatch, setFieldListUiState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react2.css)`
        height: 100%;
        display: ${isSidebarCollapsed ? 'none' : 'flex'};
        background-color: ${euiTheme.colors.body};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 7
    }
  }, selectedDataView ? /*#__PURE__*/_react.default.createElement(_unifiedFieldList.UnifiedFieldListSidebarContainer, {
    additionalFieldGroups: additionalFieldGroups,
    additionalFilters: additionalFilters,
    allFields: sidebarState.allFields,
    dataView: selectedDataView,
    fullWidth: true,
    getCreationOptions: getCreationOptions,
    onAddBreakdownField: onAddBreakdownField,
    onAddFieldToWorkspace: onAddFieldToWorkspace,
    onAddFilter: onAddFilter,
    onFieldEdited: onFieldEdited,
    onRemoveFieldFromWorkspace: onRemoveFieldFromWorkspace,
    prependInFlyout: prependDataViewPickerForMobile,
    ref: initializeUnifiedFieldListSidebarContainerApi,
    services: services,
    showFieldList: showFieldList,
    trackUiMetric: trackUiMetric,
    variant: fieldListVariant,
    workspaceSelectedFieldNames: columns,
    initialState: fieldListUiState,
    onInitialStateChange: onInitialStateChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 11
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            border-right: ${euiTheme.border.thin};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 9
    }
  })));
}