"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilePicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilePicker = ({
  fileUploadManager,
  fullWidth,
  large = false
}) => {
  const filePickerRef = (0, _react.useRef)(null);
  const onFilePickerChange = (0, _react.useCallback)(async files => {
    if (files && files.length > 0) {
      var _filePickerRef$curren;
      await fileUploadManager.addFiles(files);
      // Clear the file picker after adding files
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
    }
  }, [fileUploadManager]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, fullWidth === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 30
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.dataVisualizer.file.aboutPanel.supportedFormatsDescription', {
      defaultMessage: 'Supported formats: PDF, TXT, CSV, log files and NDJSON'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    ref: filePickerRef,
    id: "filePicker",
    fullWidth: true,
    display: large ? 'large' : 'default',
    compressed: true,
    multiple: true,
    initialPromptText: _i18n.i18n.translate('xpack.dataVisualizer.file.filePicker.selectOrDragAndDropFiles', {
      defaultMessage: 'Select or drag and drop files'
    }),
    onChange: files => onFilePickerChange(files),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))), fullWidth === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 30
    }
  }) : null);
};
exports.FilePicker = FilePicker;