"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProbabilityUsedMessage = void 0;
var _mlIsDefined = require("@kbn/ml-is-defined");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/random_sampling_menu/probability_used.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProbabilityUsedMessage = ({
  samplingProbability
}) => {
  return (0, _mlIsDefined.isDefined)(samplingProbability) ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dvRandomSamplerProbabilityUsedMsg",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.randomSamplerSettingsPopUp.probabilityLabel",
    defaultMessage: "Probability used: {samplingProbability}%",
    values: {
      samplingProbability: samplingProbability * 100
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  })) : null;
};
exports.ProbabilityUsedMessage = ProbabilityUsedMessage;