"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestValidation = getRequestValidation;
exports.getResponseValidation = getResponseValidation;
exports.isFullValidatorContainer = isFullValidatorContainer;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * {@link RouteValidator} is a union type of all possible ways that validation
 * configuration can be registered. This helper utility narrows down the type
 * by indicating whether it is {@link RouteValidatorRequestAndResponses} or not.
 * @public
 */
function isFullValidatorContainer(value) {
  return 'request' in value;
}

/**
 * Extracts {@link RouteValidatorFullConfigRequest} from the validation container.
 * This utility is intended to be used by code introspecting router validation configuration.
 * @public
 */
function getRequestValidation(value) {
  if (typeof value === 'function') value = value();
  return isFullValidatorContainer(value) ? value.request : value;
}

/**
 * Extracts {@link RouteValidatorFullConfigRequest} from the validation container.
 * This utility is intended to be used by code introspecting router validation configuration.
 * @public
 */
function getResponseValidation(value) {
  if (typeof value === 'function') value = value();
  return isFullValidatorContainer(value) ? value.response : undefined;
}