"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpdatedColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _action_column = require("./action_column");
var _editing_column = require("./editing_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/tables/inline_editable_table/get_updated_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getUpdatedColumns = ({
  columns,
  displayedItems,
  emptyPropertyAllowed = false,
  isActivelyEditing,
  canRemoveLastItem,
  isLoading = false,
  lastItemWarning,
  prevFocusRef,
  uneditableItems
}) => {
  return [...columns.map(column => {
    const newColumn = {
      name: column.name,
      render: item => {
        if (isActivelyEditing(item)) {
          return /*#__PURE__*/_react.default.createElement(_editing_column.EditingColumn, {
            column: column,
            isLoading: isLoading,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 45,
              columnNumber: 20
            }
          });
        }
        return column.render(item);
      }
    };
    return newColumn;
  }), {
    flexBasis: '200px',
    flexGrow: 0,
    render: item => /*#__PURE__*/_react.default.createElement(_action_column.ActionColumn, {
      displayedItems: displayedItems,
      emptyPropertyAllowed: emptyPropertyAllowed !== null && emptyPropertyAllowed !== void 0 ? emptyPropertyAllowed : false,
      isActivelyEditing: isActivelyEditing,
      isLoading: isLoading,
      canRemoveLastItem: canRemoveLastItem,
      lastItemWarning: lastItemWarning,
      prevFocusRef: prevFocusRef,
      uneditableItems: uneditableItems,
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    })
  }];
};
exports.getUpdatedColumns = getUpdatedColumns;