"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_INDEX_SELECTOR_OPTIONS = exports.AccessControlIndexSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/access_control_index_selector/access_control_index_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_INDEX_SELECTOR_OPTIONS = exports.DEFAULT_INDEX_SELECTOR_OPTIONS = [{
  description: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.contentIndex.description', {
    defaultMessage: 'Browse documents ingested by content syncs'
  }),
  title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.contentIndex.title', {
    defaultMessage: 'Content index'
  }),
  value: 'content-index'
}, {
  description: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.accessControl.description', {
    defaultMessage: 'Browse access control lists ingested by access control syncs'
  }),
  title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.accessControl.title', {
    defaultMessage: 'Access control index'
  }),
  value: 'access-control-index'
}];
const AccessControlIndexSelector = ({
  indexSelectorOptions = DEFAULT_INDEX_SELECTOR_OPTIONS,
  onChange,
  valueOfSelected,
  fullWidth
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: fullWidth,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.indexType.ariaLabel', {
      defaultMessage: 'Index type'
    }),
    prepend: indexSelectorOptions.some(option => option.error) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'warning',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }) : undefined,
    options: indexSelectorOptions.map(option => {
      return {
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "row",
          alignItems: "center",
          gutterSize: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 13
          }
        }, option.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          align: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 94,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: 'warning',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 19
          }
        }), ' ') : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "none",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement("h4", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 21
          }
        }, option.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 21
          }
        }, option.description))))),
        inputDisplay: option.title,
        value: option.value
      };
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
};
exports.AccessControlIndexSelector = AccessControlIndexSelector;