"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NamespaceSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/namespace_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NamespaceSelector = ({
  activeNamespace,
  namespaces,
  onNamespaceChange
}) => {
  const onSelectedNamespaceChange = (0, _react.useCallback)(newNamespace => {
    onNamespaceChange(newNamespace);
  }, [onNamespaceChange]);
  const namespaceOptions = (0, _react.useMemo)(() => {
    return namespaces.map(namespace => ({
      value: namespace,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, namespace),
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 13
        }
      }, namespace))),
      'data-test-subj': `namespace-selector-menu-item-${namespace}`
    }));
  }, [namespaces]);
  const label = _i18n.i18n.translate('xpack.csp.namespaceSelector.title', {
    defaultMessage: 'Namespace'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '250px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "namespace-selector-dropdown-button",
    options: namespaceOptions,
    valueOfSelected: activeNamespace,
    onChange: onSelectedNamespaceChange,
    disabled: namespaces.length < 2,
    hasDividers: true,
    fullWidth: true,
    compressed: true,
    "aria-label": label,
    prepend: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 18
      }
    }, label),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
};
exports.NamespaceSelector = NamespaceSelector;