"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _constants = require("../common/constants");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _parse_onboarding_default_solution = require("../common/parse_onboarding_default_solution");
var _urls = require("./urls");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cloud/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class CloudPlugin {
  constructor(initializerContext) {
    var _this$config$serverle;
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnabled", void 0);
    (0, _defineProperty2.default)(this, "contextProviders", []);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "elasticsearchConfig", void 0);
    (0, _defineProperty2.default)(this, "cloudUrls", new _urls.CloudUrlsService());
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    this.isServerlessEnabled = !!((_this$config$serverle = this.config.serverless) !== null && _this$config$serverle !== void 0 && _this$config$serverle.project_id);
    this.logger = initializerContext.logger.get();
    this.elasticsearchConfig = undefined;
  }
  setup(core) {
    var _decodedId, _decodedId2, _decodedId3, _this$config$onboardi, _this$config$serverle2, _this$config$serverle3, _this$config$serverle4, _this$config$serverle5, _this$config$serverle6, _this$config$serverle7;
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    const {
      id,
      cname,
      trial_end_date: trialEndDate,
      is_elastic_staff_owned: isElasticStaffOwned,
      csp
    } = this.config;
    let decodedId;
    if (id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(id, this.logger);
    }
    const kibanaUrl = (_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.kibanaUrl;
    this.cloudUrls.setup(this.config, core, kibanaUrl);
    return {
      cloudId: id,
      organizationId: this.config.organization_id,
      deploymentId: (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url),
      cname,
      csp,
      cloudHost: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.host,
      cloudDefaultPort: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.defaultPort,
      trialEndDate: trialEndDate ? new Date(trialEndDate) : undefined,
      isElasticStaffOwned,
      isCloudEnabled: this.isCloudEnabled,
      onboarding: {
        defaultSolution: (0, _parse_onboarding_default_solution.parseOnboardingSolution)((_this$config$onboardi = this.config.onboarding) === null || _this$config$onboardi === void 0 ? void 0 : _this$config$onboardi.default_solution)
      },
      isServerlessEnabled: this.isServerlessEnabled,
      serverless: {
        projectId: (_this$config$serverle2 = this.config.serverless) === null || _this$config$serverle2 === void 0 ? void 0 : _this$config$serverle2.project_id,
        projectName: (_this$config$serverle3 = this.config.serverless) === null || _this$config$serverle3 === void 0 ? void 0 : _this$config$serverle3.project_name,
        projectType: (_this$config$serverle4 = this.config.serverless) === null || _this$config$serverle4 === void 0 ? void 0 : _this$config$serverle4.project_type,
        orchestratorTarget: (_this$config$serverle5 = this.config.serverless) === null || _this$config$serverle5 === void 0 ? void 0 : _this$config$serverle5.orchestrator_target,
        // Hi fellow developer! Please, refrain from using `productTier` from this contract.
        // It is exposed for informational purposes (telemetry and feature flags). Do not use it for feature-gating.
        // Use `core.pricing` when checking if a feature is available for the current product tier.
        productTier: (_this$config$serverle6 = this.config.serverless) === null || _this$config$serverle6 === void 0 ? void 0 : _this$config$serverle6.product_tier,
        organizationInTrial: (_this$config$serverle7 = this.config.serverless) === null || _this$config$serverle7 === void 0 ? void 0 : _this$config$serverle7.in_trial
      },
      registerCloudService: contextProvider => {
        this.contextProviders.push(contextProvider);
      },
      fetchElasticsearchConfig: this.fetchElasticsearchConfig.bind(this, core.http),
      ...this.cloudUrls.getUrls(),
      // TODO: Deprecate directly accessing URLs, use `getUrls` instead
      getPrivilegedUrls: this.cloudUrls.getPrivilegedUrls.bind(this.cloudUrls),
      getUrls: this.cloudUrls.getUrls.bind(this.cloudUrls)
    };
  }
  start(coreStart) {
    var _this$config$serverle8, _this$config$serverle9, _this$config$serverle10, _this$config$serverle11;
    coreStart.chrome.setHelpSupportUrl((0, _utils.getSupportUrl)(this.config));

    // Nest all the registered context providers under the Cloud Services Provider.
    // This way, plugins only need to require Cloud's context provider to have all the enriched Cloud services.
    const CloudContextProvider = ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.contextProviders.reduce((acc, ContextProvider) => /*#__PURE__*/_react.default.createElement(ContextProvider, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 15
        }
      }, " ", acc, " "), children));
    };
    return {
      CloudContextProvider,
      isCloudEnabled: this.isCloudEnabled,
      cloudId: this.config.id,
      isServerlessEnabled: this.isServerlessEnabled,
      serverless: {
        projectId: (_this$config$serverle8 = this.config.serverless) === null || _this$config$serverle8 === void 0 ? void 0 : _this$config$serverle8.project_id,
        projectName: (_this$config$serverle9 = this.config.serverless) === null || _this$config$serverle9 === void 0 ? void 0 : _this$config$serverle9.project_name,
        projectType: (_this$config$serverle10 = this.config.serverless) === null || _this$config$serverle10 === void 0 ? void 0 : _this$config$serverle10.project_type,
        organizationInTrial: (_this$config$serverle11 = this.config.serverless) === null || _this$config$serverle11 === void 0 ? void 0 : _this$config$serverle11.in_trial
      },
      fetchElasticsearchConfig: this.fetchElasticsearchConfig.bind(this, coreStart.http),
      ...this.cloudUrls.getUrls(),
      // TODO: Deprecate directly accessing URLs, use `getUrls` instead
      getPrivilegedUrls: this.cloudUrls.getPrivilegedUrls.bind(this.cloudUrls),
      getUrls: this.cloudUrls.getUrls.bind(this.cloudUrls)
    };
  }
  stop() {}
  async fetchElasticsearchConfig(http) {
    if (this.elasticsearchConfig !== undefined) {
      // This config should be fully populated on first fetch, so we should avoid refetching from server
      return this.elasticsearchConfig;
    }
    try {
      const result = await http.get(_constants.ELASTICSEARCH_CONFIG_ROUTE, {
        version: '1'
      });
      this.elasticsearchConfig = {
        elasticsearchUrl: result.elasticsearch_url || undefined
      };
      return this.elasticsearchConfig;
    } catch {
      this.logger.error('Failed to fetch Elasticsearch config');
      return {
        elasticsearchUrl: undefined
      };
    }
  }
}
exports.CloudPlugin = CloudPlugin;