"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _filters = require("./filters");
var _recent_cases = require("./recent_cases");
var _kibana = require("../../common/lib/kibana");
var _navigation = require("../../common/navigation");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _get_filter_options = require("./get_filter_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/recent_cases/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RecentCases = exports.default = /*#__PURE__*/_react.default.memo(props => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(RecentCasesComponent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  })));
});
RecentCases.displayName = 'RecentCases';

// eslint-disable-next-line import/no-default-export

const RecentCasesComponent = /*#__PURE__*/_react.default.memo(({
  maxCasesToShow
}) => {
  const currentUser = (0, _kibana.useCurrentUser)();
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    getAllCasesUrl,
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const [recentCasesFilterBy, setRecentCasesFilterBy] = (0, _react.useState)('recentlyCreated');
  const navigateToAllCasesClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToAllCases();
  }, [navigateToAllCases]);
  const recentCasesFilterOptions = (0, _react.useMemo)(() => {
    if (recentCasesFilterBy === 'myRecentlyAssigned') {
      return (0, _get_filter_options.getAssigneeFilter)({
        isLoadingCurrentUserProfile,
        currentUserProfile
      });
    }
    return (0, _get_filter_options.getReporterFilter)({
      currentUser,
      isLoadingCurrentUserProfile,
      recentCasesFilterBy,
      currentUserProfile
    });
  }, [currentUser, currentUserProfile, isLoadingCurrentUserProfile, recentCasesFilterBy]);

  // show the recently reported if we have the current user profile, or if we have the fallback user information
  const hasCurrentUserInfo = currentUserProfile != null || currentUser != null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, i18n.RECENT_CASES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_filters.RecentCasesFilters, {
    filterBy: recentCasesFilterBy,
    setFilterBy: setRecentCasesFilterBy,
    hasCurrentUserInfo: hasCurrentUserInfo,
    isLoading: isLoadingCurrentUserProfile,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_recent_cases.RecentCasesComp, {
    filterOptions: recentCasesFilterOptions,
    maxCasesToShow: maxCasesToShow,
    recentCasesFilterBy: recentCasesFilterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: navigateToAllCasesClick,
    href: getAllCasesUrl(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, ' ', i18n.VIEW_ALL_CASES))));
});
RecentCasesComponent.displayName = 'RecentCasesComponent';
module.exports = exports.default;